package com.bcxin.risk.activity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.bcxin.risk.activity.dto.data.ActivityDataDTO;
import com.bcxin.risk.activity.dto.data.BLBCommunicationDto;
import com.bcxin.risk.activity.dto.search.ActivitySearchDTO;
import com.bcxin.risk.base.dao.QueryHelper;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.DomainDateUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.constant.TableConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;


@Repository("activityDao")
public class ActivityDaoImpl extends DaoImpl<Activity> implements ActivityDao {

    @Override
    public List<Activity> activityList(){
        return selectList();
    }


    @Override
    public Activity findActivityByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public Activity findActivityByName(String name){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("name", name);
        List<Object> list = selectList(wrapper);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return (Activity) list.get(0);
    }

    @Override
    public List<ActivityDataDTO> findActivityByActivityName(String activityName,String filterId) {
        String sql = "SELECT a.oid from risk_activity a " +
                " inner join risk_orderForm o on o.activity_id = a.oid" +
                " where a.name = '"+activityName+"'" +
                " and o.orderStatus != " + DictConst.ORDERSTATUS_CANCEL +
                " and o.orderStatus != " + DictConst.ORDERSTATUS_YSC ;
        if(StringUtil.isNotEmpty(filterId)){
            sql+=" and a.oid !='"+filterId+"'" ;
        }
        SelectWrapper wrapper = SelectWrapper.instance();
        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        List<Map<String, Object>> list = queryMaps(sql, wrapper);
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public Activity findActivityByActivityNo(String activityNo) {
        return selectOne(SelectWrapper.instance().eq("activityNo", activityNo));
    }

    @Override
    public List<ActivityDataDTO> findActivityDtoList(ActivitySearchDTO searchDto,
                                                     Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();

        if (searchDto != null) {
            if (searchDto.getActivityStatus() != null) {
                wrapper.eq("activityStatus", searchDto.getActivityStatus());
            }
            if (searchDto.getSponsor() != null) {
                wrapper.like("sponsor", searchDto.getSponsor());
            }
            if (searchDto.getOrderNo() != null) {
                wrapper.eq("orderNo", searchDto.getOrderNo());
            }
            if (searchDto.getStarttime() != null) {
                wrapper.ge("createOn", DomainDateUtil.parseDate(searchDto.getStarttime()));
            }
            if (searchDto.getEndtime() != null) {
                wrapper.le("endDate", DomainDateUtil.parseDate(searchDto.getEndtime()));
            }
            if (searchDto.getUser() != null) {
                wrapper.eq("user_id", searchDto.getUser().getOid());
            }
            if (searchDto.getActivityType() != null) {
                wrapper.eq("activityType", searchDto.getActivityType());
            }
            if (StringUtil.isNotEmpty(searchDto.getName())) {
                wrapper.like("name", searchDto.getName());
            }

        }
        wrapper.orderBy("updateOn", false);
        wrapper.orderBy("oid",false);
        List<Map<String, Object>> list = Lists.newArrayList();
        if (page == null) {
            list = queryMaps("select * from risk_activity ", wrapper);
        } else {
            Page rpage = queryMapsPage("select * from risk_activity ", wrapper, page);
            list = rpage.getRecords();
        }

        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            ActivityDataDTO dto = BeanUtil.mapToBean(result,ActivityDataDTO.class,true);
            dto.setPage(page);
            dtoList.add(dto);
        });

        return dtoList;
    }

    /**
     *
     * <b>Function 查找所有活动或者根据用户条件查询，并转成dto</b>
     *
     * @param page
     * @return
     * @author wangchenyi
     * @date 2017年03月08日 下午11:31:13
     * @注意事项 </b> <b>
     */
    @Override
    public List<ActivityDataDTO> findActivityList(ActivitySearchDTO searchDto, Page page) {
        String sql = "SELECT oid," +
                            " name," +
                            " address," +
                            " activityStatus," +
                            " gov," +
                            " (SELECT label " +
                              "  FROM sys_dict" +
                              " WHERE type = 'activityStatus'" +
                                " AND value = risk_activity.activityStatus) AS activityStatusLabel ,"+
                            " (SELECT label  " +
                              "  FROM sys_dict " +
                              " WHERE value = risk_activity.activityType) AS activityType "+
                      " FROM risk_activity " ;
        if (searchDto != null) {
            if (StringUtil.isNotEmpty(searchDto.getActivityStatus())) {
                sql = sql+ " AND activityStatus ='"+searchDto.getActivityStatus()+"' ";
            }
            if (StringUtil.isNotEmpty(searchDto.getSponsor())) {
                sql = sql+ " AND sponsor like'%"+searchDto.getSponsor()+"%' ";
            }
            if (StringUtil.isNotEmpty(searchDto.getStartDate())) {
                sql = sql+ " AND startDate <='"+searchDto.getStartDate()+"' ";
            }
            if (StringUtil.isNotEmpty(searchDto.getEndDate())) {
                sql = sql+ " AND endDate >='"+searchDto.getEndDate()+"' ";
            }
            if (searchDto.getUser()!=null) {
                sql = sql+ " AND user_id ="+searchDto.getUser().getOid()+" ";
            }
            if (searchDto.getActivityType() != null) {
                sql = sql+ " AND activityType ='"+searchDto.getActivityType()+"' ";
             }

            if (StringUtil.isNotEmpty(searchDto.getName())) {
                sql = sql+ " AND name like'%"+searchDto.getName()+"%' ";
            }
        }
        sql = sql + "ORDER BY createOn DESC";
        SelectWrapper wrapper = SelectWrapper.instance();
        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }


    /**
     * 历史活动查询
     * @param searchDto
     * @param page
     * @return
     */
    @Override
    public List findActivityHistoryList(ActivitySearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT " +
                " a.oid," +
                " a.createOn," +
                " a.activityNo," +
                " a.name," +
                " a.sponsor," +
                " o.name as assessment," +
                " p.province," +
                " c.city," +
                " area.area" +
                " FROM risk_activity a" +
                " inner join risk_activity_cooper ac on ac.activity_id = a.oid" +
                " inner join risk_serviceorg so on so.oid = ac.org_id " +
                " inner join risk_org o on o.oid = so.oid" +
                " inner join sys_region p on p.oid = a.province_id" +
                " inner join sys_region c on c.oid = a.city_id" +
                " left join sys_region area on area.oid = a.area_id" +
                " where 1=1" +
                " and so.serviceOrgType = '"+DictConst.SERVICEORGTYPE_FXPGJG +"'" +
                " and a.activitysource = '"+DictConst.ACTIVITYSOURCE_XTLR+"' " ;

        if (StringUtil.isNotEmpty(searchDto.getActivityNo())) {
            sql = sql+ " AND a.activityNo = '"+searchDto.getActivityNo()+"' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getName())) {
            sql = sql+ " AND a.name like '%"+searchDto.getName()+"%' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getSponsor())) {
            sql = sql+ " AND sponsor like'%"+searchDto.getSponsor()+"%' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getAssessment())) {
            sql = sql+ " AND o.name like '%"+searchDto.getAssessment()+"%' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getProvince())) {
            sql = sql+ " AND a.province_id = "+searchDto.getProvince()+" ";
        }
        if (StringUtil.isNotEmpty(searchDto.getCity())) {
            sql = sql+ " AND a.city_id = "+searchDto.getCity()+" ";
        }
        if (StringUtil.isNotEmpty(searchDto.getArea())) {
            sql = sql+ " AND a.area_id = "+searchDto.getArea()+" ";
        }

        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql = sql + " ORDER BY a.oid DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }


    @Override
    public Map<String, String> countActivity(ActivitySearchDTO dto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuilder sql = new StringBuilder(
                "select count(1) as allTotal,"
                        + " sum(case r.activityStatus when '"+ DictConst.ACTIVITYSTATUS_HDJS+"' then 1 else 0 end) as complete,"
                        + " sum(case r.activityStatus when '"+ DictConst.ACTIVITYSTATUS_HDJS+"' then 0 else 1 end) as uncomplete"
                        + " from "+TableConst.ACTIVITY_TABLE+" r" + " ");
        if (dto.getUser() == null) {
            return Maps.newHashMap();
        } else {
            wrapper.eq("user_id", dto.getUser().getOid());
        }
        Map<String, String> countMap = Maps.newHashMap();
        Map<String, Object> result = queryMap(sql.toString(),wrapper);
        countMap.put("allTotal", result.get("allTotal") == null ? "0"
                : result.get("allTotal").toString());
        countMap.put("complete", result.get("complete") == null ? "0"
                    : result.get("complete").toString());
        countMap.put("uncomplete", result.get("uncomplete") == null ? "0"
                    : result.get("uncomplete").toString());
        return countMap;
    }

    @Override
    public List<ActivityDataDTO> findActivityByApprovalStatus(ActivitySearchDTO activitySearchDTO, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select " +
                " DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                " a.oid,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn," +
                " p.province AS province ," +
                " c.city AS city ," +
                " area.area AS area ," +
                " a.`name` AS name ," +
                " a.activitySource ," +
                " a.address AS address," +
                " a.sponsor AS sponsor ," +
                " a.activityStatus ," +
                " a.oid AS activityId ," +
                " a.startDate AS startDate ," +
                " a.endDate AS endDate " +
                " from risk_activity a " +
                " inner join sys_region p on p.oid = a.province_id " +
                " inner join sys_region c on c.oid = a.city_id " +
                " left join sys_region area on area.oid = a.area_id" ;
        sql += " where a.province_id = '" + activitySearchDTO.getProvince() + "' ";

        if (StringUtil.isNotEmpty(activitySearchDTO.getCity())) {
            sql += " and a.city_id = '" + activitySearchDTO.getCity() + "' ";
        }
        if (StringUtil.isNotEmpty(activitySearchDTO.getArea())) {
            sql += " and a.area_id  = '" + activitySearchDTO.getArea() + "' ";
        }

        wrapper.orderBy("a.createOn", false);
        wrapper.orderBy("a.oid", false);
        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    /**
     * 根据承办方，和活动选择的评估机构，获取承办方与评估机构的合作历史次数
     * @param user
     * @param orgId
     * @return
     */
    @Override
    public Map<String, String> getActivitySuccessCount(User user,Long orgId) {

        StringBuilder sql = new StringBuilder(
                " select count(od.oid) as complete from "+ TableConst.ORDERFORM_TABLE+" od "
                        + " inner join "+TableConst.USER_TABLE+" se on se.oid = od.user_Id"
                        + " inner join risk_activity a on a.oid = od.activity_id"
                        + " inner join risk_activity_cooper cp on cp.activity_id = a.oid ");

        if (user == null) {
            return Maps.newHashMap();
        }
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("od.orderStatus",DictConst.ORDERSTATUS_YZF);
        wrapper.eq("se.oid",user.getOid());
        wrapper.eq("cp.org_id",orgId);

        Map<String, String> countMap = Maps.newHashMap();
        List<Map<String, Object>> list = queryMaps(sql.toString(), wrapper);
        for (Object object : list) {
            Map<String, Object> result = (Map<String, Object>) object;
            countMap.put("complete", result.get("complete") == null ? "0"
                    : result.get("complete").toString());
        }
        return countMap;

    }



    @Override
    public List<BLBCommunicationDto> findBLBCommunicationDtoList(Long userId,String activityType) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT a.oid as activity_id ,a.name " +
                "   FROM risk_activity a ,risk_orderform c" +
                "  WHERE a.oid = c.activity_id " +
                "    AND (c.orderStatus = " + DictConst.ORDERSTATUS_YZF + " or c.orderStatus = " + DictConst.ORDERSTATUS_YHZF + ")" +
                "    AND a.user_id = '"+ userId +"' "+
                "    AND NOT exists  (SELECT 1 " +
                "                      FROM risk_insurancePolicy b" +
                "                     WHERE a.oid = b.activity_id) " ;

        /* 需求变更 20180912 钟雪峰 */
        if ("TY".equals(activityType)) {
            sql +=  "    AND (a.activityType = '"+DictConst.ACTIVITYTYPE_TYBSHD+"' or a.activityType = '"+DictConst.ACTIVITYTYPE_GYCSHD+"')";
        } else if ("WY".equals(activityType)) {
            sql +=  "    AND (a.activityType = '"+DictConst.ACTIVITYTYPE_WYYCHD+"' or a.activityType = '"+DictConst.ACTIVITYTYPE_GYCSHD+"')";
        } else if ("ZL".equals(activityType)) {
            sql +=  "    AND (a.activityType = '"+DictConst.ACTIVITYTYPE_ZLZXDHD+"' or a.activityType = '"+DictConst.ACTIVITYTYPE_ZPHHD+"' or a.activityType = '"+DictConst.ACTIVITYTYPE_GYCSHD+"' )";
        } else if ("QT".equals(activityType)) {
            sql +=  "    AND (a.activityType = '"+DictConst.ACTIVITYTYPE_YYDHHD+"' or a.activityType = '"+DictConst.ACTIVITYTYPE_GYCSHD+"' or a.activityType = '"+DictConst.ACTIVITYTYPE_QT+"')";
        }
        wrapper.orderBy("a.createOn",false);
        List<BLBCommunicationDto> dtoList = Lists.newArrayList();
        List<Map<String, Object>> list  = queryMaps(sql, wrapper);
        list.forEach(result -> {
            BLBCommunicationDto dto = new BLBCommunicationDto(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public List<ActivityDataDTO> findTicketList(ActivitySearchDTO searchDto, Page page) {
        StringBuffer stringBuffer = new StringBuffer("SELECT ra.oid,ra.`name`,ra.startDate,ra.endDate,ra.number,ra.days,dict.label as activityType");
        stringBuffer.append(" FROM risk_activity ra");
        stringBuffer.append(" INNER JOIN sys_dict dict ON ra.activityType = dict.value and dict.type = 'ActivityType' ");
        SelectWrapper wrapper = SelectWrapper.instance();

        if(StringUtil.isNotEmpty(searchDto.getName())){
            wrapper.like("ra.name",searchDto.getName());
        }
        wrapper.orderBy("ra.createOn", false);
        wrapper.orderBy("ra.oid",false);
        List<Map<String, Object>> list = Lists.newArrayList();
        if (page == null) {
            list = queryMaps(stringBuffer.toString(), wrapper);
        } else {
            Page rpage = queryMapsPage(stringBuffer.toString(), wrapper, page);
            list = rpage.getRecords();
        }

        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            ActivityDataDTO dto = BeanUtil.mapToBean(result,ActivityDataDTO.class,true);
            dto.setPage(page);
            dtoList.add(dto);
        });

        return dtoList;
    }


    /**
     *
     * <b>Function </b> 根据承办方查找有效的活动且并未投保的活动，并转成dto
     *
     * @return
     * @author LuoPeng
     * @date 2016年12月21日 下午5:31:13
     * @注意事项 </b> <b>
     */
    @Override
    public List<ActivityDataDTO> findUnInsureReportList(User user, String productType) {
        Map<String, Object> paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder(
                "select  a.oid,a.name " +
                        "from " +
                        "risk_orderform o inner join risk_activity a on a.oid = o.activity_id  " +
                        "inner join risk_se_user se on se.oid = o.user_id  " +
                        "inner join risk_insuranceproduct i on i.activityType = t.oid " +
                        "where " +
                        "  1=1 " +
                        "  and i.productType =:productone  " +
                        "  and se.oid =:seoidone  " +
                        "  and o.orderStatus = 1  " +
                        "  and  a.oid not in  ( select " +
                        "  aa.oid " +
                        "  from risk_orderform oo  inner join risk_activity aa on aa.oid = oo.activity_id  " +
                        "  inner join risk_se_user see on see.oid = oo.user_id  " +
                        "  inner join risk_insurancepolicy pol on pol.activity_id = aa.oid  " +
                        "  inner join risk_insuranceproduct ii on ii.activityType = tt.oid"+
                        "  where" +
                        "  1=1 " +
                        "  and ii.productType =:producttwo " +
                        "  and see.oid =:seoidtwo  " +
                        "  and oo.orderStatus = 1)" );

        if (user == null || productType == null) {
            return Lists.newArrayList();
        }
        paramMap.put("productone", productType);
        paramMap.put("producttwo", productType);
        paramMap.put("seoidone", user.getOid());
        paramMap.put("seoidtwo", user.getOid());
//        paramMap.put("statusone", ReportStatus.EFFECT.toString());
//        paramMap.put("statustwo", ReportStatus.EFFECT.toString());
//        paramMap.put("activeone", Active.Y.toString());
//        paramMap.put("activetwo", Active.Y.toString());

        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            ActivityDataDTO dto = new ActivityDataDTO(map);
            dtoList.add(dto);
        });

        return dtoList;
    }


    /**
     * 根据评估机构获取对应的活动
     * @param orgId
     * @return
     */
    @Override
    public List<ActivityDataDTO> findActivityByOrgId(Long orgId){
        String sql="SELECT A.oid,A.name from risk_activity A,risk_activity_cooper B " +
                " where A.oid=B.activity_id and B.org_id="+orgId+" order by A.createOn desc";
        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        List<Object> list = QueryHelper.findBySql(sql, null);
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            ActivityDataDTO dto = new ActivityDataDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    /**
     * 根据承办方获取对应的活动
     * @param contractId
     * @return
     */
    @Override
    public List<ActivityDataDTO> findActivityByContractId(Long contractId){
        String sql="select t.oid ,t.`name` from risk_activity t where t.org_id="+contractId+" order by t.createOn desc";
        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        List<Object> list = QueryHelper.findBySql(sql.toString(), null);
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            ActivityDataDTO dto = new ActivityDataDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public Map<String, String> activityCount(Long oid) {

        StringBuilder sql = new StringBuilder(" SELECT SUM(b.amount) AS amount,COUNT(1) AS count FROM risk_activity a " +
                "                INNER JOIN risk_orderForm b on a.oid =b.activity_id" +
                "                INNER JOIN risk_org c ON a.org_id = c.oid " +
                "                INNER JOIN risk_activity_cooper e ON a.org_id = e.org_id " +
                " WHERE e.org_id = " + oid + " " +
                " and a.activitySource != '"+DictConst.ACTIVITYSOURCE_XTLR+"' ");

        SelectWrapper wrapper = SelectWrapper.instance();

        Map<String, String> countMap = Maps.newHashMap();
        List<Map<String, Object>> list = queryMaps(sql.toString(), wrapper);
        if (list != null && list.size() > 0) {
            for (Object object : list) {
                Map<String, Object> result = (Map<String, Object>) object;
                countMap.put("amount", result.get("amount") == null ? "0"
                        : result.get("amount").toString());
                countMap.put("count", result.get("count") == null ? "0"
                        : result.get("count").toString());
            }
        } else {
            countMap.put("amount", "0");
            countMap.put("count", "0");
        }
        return countMap;
    }

    @Override
    public List<Map<String, Object>> countAmountByActivity(Long oid) {
        StringBuilder sql = new StringBuilder(
                " SELECT a.activityType, sum(b.amount) AS amount " +
                     " FROM risk_activity a " +
                     " INNER JOIN risk_orderForm b on a.oid = b.activity_id " +
                     " INNER JOIN risk_org c ON a.org_id = c.oid " +
                     " INNER JOIN risk_activity_cooper e ON a.oid = e.activity_id " +
                     " WHERE e.org_id = " + oid + " and a.activitySource != '"+DictConst.ACTIVITYSOURCE_XTLR+"'" +
                     " GROUP BY a.activityType");

        SelectWrapper wrapper = SelectWrapper.instance();

        List<Map<String, Object>> list = queryMaps(sql.toString(), wrapper);

        return list;
    }

    /**
     * 获取需要推送的活动
     * @param isPushToSB
     * @return
     */
    @Override
    public List<Activity> activityPushList(String isPushToSB){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("isPushToSB", isPushToSB);
        wrapper.eq("pushResult",DictConst.N);
        return selectList(wrapper);
    }

    /**
     * 获取已经开始的活动
     * @return
     */
    @Override
    public List<Activity> activityStarList(){
        SelectWrapper wrapper = SelectWrapper.instance();
        Date now = DateUtil.date();
        wrapper.gt("startDate", now);
        return selectList(wrapper);
    }
}
