package com.bcxin.risk.policy;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import com.bcxin.risk.policy.dto.data.PolicyDto;
import com.bcxin.risk.policy.dto.search.PolicySearchDto;
import com.bcxin.risk.policy.enums.PolicyStatus;
import com.bcxin.risk.user.domain.User;

import java.util.List;

public interface InsurancePolicyDao extends IDao<InsurancePolicy> {
	
	List<InsurancePolicy> findPolicyByUser(User user);
	
	List<PolicyDto> findPolicyList(PolicySearchDto searchDto, DwzPage page);

	InsurancePolicy findInsurancePolicyByOid(Long oid);

	List<InsurancePolicy> findInsurancePolicyList(PolicySearchDto searchDto, Page page);

	void updReportPolicyStatus(Activity activity, PolicyStatus status);

	InsurancePolicy findPolicyByActivity(Activity activity);
	public List<PolicyDto> findPolicyByUserPage(PolicySearchDto searchDto,Page page);
}
