package com.bcxin.risk.order;

import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.order.dto.TransactionDataDto;
import com.bcxin.risk.order.dto.search.TransactionSearchDto;
import com.bcxin.risk.policy.domain.InsurancePolicy;

import java.util.List;
import java.util.Map;

public interface TransactionDao extends IDao<Transaction> {

    Transaction findTransactionByOid(Long oid);

    Transaction findTransactionByPolicy(InsurancePolicy insurancePolicy);

    List<Transaction> findTransactionList(TransactionSearchDto searchDto, Page page);

    Transaction findTransactionByOrder(OrderForm orderForm);

    Map queryPgbgSubmitConditon (Long orderId);

    List<TransactionDataDto>  findTransactionByOrderId(Long orderForm_id);

    Long findTransactionIdByOrder(OrderForm orderForm);

    void deleteTransaction(Long transactionId);

    void deleteorderForm(OrderForm orderForm);
}
