package com.bcxin.risk.expert;

import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.expert.domain.ExpertCheckInfo;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.user.dto.data.ExpertCheckInfoDto;

import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 专家待审核资料DAO层
 */
public interface ExpertCheckInfoDao extends IDao<ExpertCheckInfo> {

    /**
     * 根据主键ID获取专家待审核资料实体
     * @param oid 主键ID
     * @return
     */
    ExpertCheckInfo findByOid(Long oid);

    /**
     * 根据用户ID获取专家待审核资料实体
     * @param userId 专家用户ID
     * @return
     */
    ExpertCheckInfo findByUserId(Long userId);

    /**
     * 根据状态查询专家资料信息列表
     * @param checkStatus 审核状态
     * @return 资料列表
     */
    List<ExpertCheckInfo> findCheckList(String checkStatus);

    /**
     * 分页查询
     * @param expertCheckInfoDto
     * @param page
     * @return
     */
    List<Map<String, Object>> reviewExpertList(ExpertCheckInfoDto expertCheckInfoDto, DwzPage page);

    /**
     * 根据主键ID获取专家待审核资料Map对象
     * @param oid 主键ID
     * @return
     */
    List<Map<String, Object>> selectExpertCheckInfoById(Long oid);

    List<ExpertCheckInfo> newReviewExpertList();
}
