/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.survey;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.SurveyTaskDao;
import com.bcxin.risk.survey.domain.SurveyTask;
import com.bcxin.risk.survey.domain.Task;
import com.bcxin.risk.survey.domain.dto.serach.SurveyTaskSerachDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="surveyTaskDao")
public class SurveyTaskDaoImpl
extends DaoImpl<SurveyTask>
implements SurveyTaskDao {
    @Autowired
    private BaseDao baseDao;

    public SurveyTask findSurveyTaskByOid(Long oid) {
        return (SurveyTask)this.selectById(oid);
    }

    public List<SurveyTask> findSurveyTaskList(SurveyTaskSerachDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getActivity() != null) {
            criterionList.add(Restrictions.eq((String)"activity", (Object)searchDto.getActivity()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getName())) {
            criterionList.add(Restrictions.eq((String)"name", (Object)searchDto.getName()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getTaskCode())) {
            criterionList.add(Restrictions.eq((String)"taskCode", (Object)searchDto.getTaskCode()));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public SurveyTask findSurveyTaskByTask(Task task) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"task", (Object)task));
        List list = this.baseDao.findByCriterion(SurveyTask.class, (List)criterionList);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return (SurveyTask)list.get(0);
        }
        return null;
    }
}

