/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.report;

import cn.hutool.core.bean.BeanUtil;
import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.common.dto.data.SurveyReportDto;
import com.bcxin.risk.hibernateplus.condition.UpdateWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.report.enums.SurveyStep;
import com.bcxin.risk.report.material.dao.ReportDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class ReportDaoImpl
extends DaoImpl<Report>
implements ReportDao {
    public Report findReportByActivity(Activity activity) {
        List list = this.selectList((Criterion)Restrictions.eq((String)"activity", (Object)activity));
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (Report)list.get(0);
    }

    public Report getReportByOid(long oid) {
        return (Report)this.selectById(oid);
    }

    public List<SurveyReportDto> getSurveyReportList(Long activityId) {
        StringBuffer sql = new StringBuffer("select rsq.surveyStep,rsq.reportPath as 'surveyReport',sv.`name` as 'venueName'");
        sql.append("from risk_survey_questionnaire rsq,risk_survey_feedback rsf,risk_surveytask rs,sys_Venue sv");
        sql.append(" where rs.activityId=" + activityId);
        sql.append(" and rsq.feedBackId = rsf.oid");
        sql.append(" and rsf.taskId=rs.oid");
        sql.append(" and sv.oid=rsq.venueId");
        sql.append(" union select surveyStep,surveyReport,sv.`name`  as 'venueName'");
        sql.append(" from risk_survey_rectification rsr,sys_Venue sv");
        sql.append(" where rsr.activity_id=" + activityId);
        sql.append(" and rsr.venue_id=sv.oid");
        List list = this.queryMaps(sql.toString());
        ArrayList<SurveyReportDto> resultList = new ArrayList<SurveyReportDto>();
        list.forEach(map -> {
            SurveyReportDto surveyReport = (SurveyReportDto)BeanUtil.mapToBean((Map)map, SurveyReportDto.class, (boolean)true);
            SurveyStep surveyStep = SurveyStep.convert((String)surveyReport.getSurveyStep());
            if (surveyStep == null) {
                surveyStep = SurveyStep.convertValue((String)surveyReport.getSurveyStep());
            }
            if (surveyStep != null) {
                surveyReport.setSurveyStep(surveyStep.getName());
            }
            resultList.add(surveyReport);
        });
        return resultList;
    }

    public int updateReportEsignFlowId(long reportId, String flowId) {
        UpdateWrapper wrapper = UpdateWrapper.instance();
        wrapper.set("esignFlowId", "'" + flowId + "'");
        wrapper.eq("oid", (Object)reportId);
        return this.update((Wrapper)wrapper);
    }

    public Report getReportByEsignFlowId(String flowId) {
        List list = this.selectList((Criterion)Restrictions.eq((String)"esignFlowId", (Object)flowId));
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (Report)list.get(0);
    }

    public List<Object> findReportDetailBySQL(String start_datetime, String end_datetime) {
        String sql_where = " where 1=1 ";
        if (end_datetime.length() > 0) {
            sql_where = sql_where + " and endDate >= '" + start_datetime + "' ";
        }
        if (start_datetime.length() > 0) {
            sql_where = sql_where + " and startDate <= '" + end_datetime + "' ";
        }
        String sql = "select count(*),sum(number) FROM risk_activity  ";
        sql = sql + sql_where + "  ";
        Session session = this.sessionFactory.getCurrentSession();
        List infolist = null;
        SQLQuery query = session.createSQLQuery(sql);
        infolist = query.list();
        return infolist;
    }

    public List<Object> findReportDetailBySQL(String end_datetime) {
        String sql_where = " where 1=1 ";
        if (end_datetime.length() > 0) {
            sql_where = sql_where + " and endDate >= '" + end_datetime + "' ";
            sql_where = sql_where + " and startDate <= '" + end_datetime + "' ";
        }
        String sql = "select count(*),sum(number) FROM risk_activity  ";
        sql = sql + sql_where + "  ";
        Session session = this.sessionFactory.getCurrentSession();
        List infolist = null;
        SQLQuery query = session.createSQLQuery(sql);
        infolist = query.list();
        return infolist;
    }
}

