/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.activity;

import com.bcxin.risk.activity.Quotation;
import com.bcxin.risk.activity.QuotationDao;
import com.bcxin.risk.activity.dto.data.QuotationDTO;
import com.bcxin.risk.activity.dto.search.QuotationSearchDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class QuotationDaoImpl
extends DaoImpl<Quotation>
implements QuotationDao {
    public Quotation findQuotationByOid(Long oid) {
        return (Quotation)this.selectById(oid);
    }

    public List<Quotation> findQuotationList(QuotationSearchDTO searchDTO) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDTO.getOrg() != null) {
            criterionList.add(Restrictions.eq((String)"org", (Object)searchDTO.getOrg()));
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getActive())) {
            criterionList.add(Restrictions.eq((String)"active", (Object)searchDTO.getActive()));
        }
        return this.selectList(criterionList);
    }

    public List<QuotationDTO> findQuotationList(QuotationSearchDTO searchDTO, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDTO.getOrg() != null) {
            criterionList.add(Restrictions.eq((String)"org", (Object)searchDTO.getOrg()));
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getActive())) {
            criterionList.add(Restrictions.eq((String)"active", (Object)searchDTO.getActive()));
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getKeyName())) {
            criterionList.add(Restrictions.like((String)"name", (Object)("%" + searchDTO.getKeyName() + "%")));
        }
        ArrayList dtoList = Lists.newArrayList();
        List list = Lists.newArrayList();
        list = page == null ? this.selectList(criterionList) : this.selectPage(criterionList, page);
        for (Quotation q : list) {
            QuotationDTO dto = new QuotationDTO(q);
            dto.setPage(page);
            dtoList.add(dto);
        }
        return dtoList;
    }

    public Quotation getQuotationByName(String name, String orgId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("name", (Object)name);
        wrapper.eq("org_id", (Object)orgId);
        wrapper.eq("active", (Object)"1");
        List list = this.selectList((Wrapper)wrapper);
        if (list.size() > 0) {
            return (Quotation)list.get(0);
        }
        return null;
    }
}

