package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxOrderRelation;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.bcx.BcxOrderRelationResponse;
import com.zbkj.service.dao.bcx.BcxOrderRelationDao;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 主订单关系表 服务实现类
 */
@Service
public class BcxOrderRelationServiceImpl extends ServiceImpl<BcxOrderRelationDao, BcxOrderRelation> implements BcxOrderRelationService {

    @Resource
    private BcxOrderRelationDao dao;

    @Override
    public BcxOrderRelation queryById(Integer id) {
        return dao.selectById(id);
    }

    @Override
    public List<BcxOrderRelationResponse> queryByOrderNo(String orderNo, Boolean isPlatOrderNo) {
        LambdaQueryWrapper<BcxOrderRelation> lqw = new LambdaQueryWrapper<>();
        lqw.eq(BcxOrderRelation::getOrderNo, orderNo);
        BcxOrderRelation bcxOrderRelation = dao.selectOne(lqw);
        if (bcxOrderRelation != null && StrUtil.isNotBlank(bcxOrderRelation.getMasterOrderNo())) {
            HashMap<String, Object> queryParam = new HashMap<>();
            queryParam.put("orderNo", orderNo);
            queryParam.put("masterOrderNo", bcxOrderRelation.getMasterOrderNo());
            queryParam.put("isPlatOrderNo", isPlatOrderNo);
            return dao.queryByMasterOrderNo(queryParam);
        }
        return CollUtil.newArrayList();
    }

    @Override
    public PageInfo<BcxOrderRelation> queryPagedList(BcxOrderRelation request,
                                                     PageParamRequest pageParamRequest) {
        LambdaQueryWrapper<BcxOrderRelation> lqw = new LambdaQueryWrapper<>();
        lqw.eq(BcxOrderRelation::getId, request.getId());
        Page<BcxOrderRelation> page = PageHelper.startPage(pageParamRequest.getPage(), pageParamRequest.getLimit());
        List<BcxOrderRelation> sources = dao.selectList(lqw);
        if (CollUtil.isEmpty(sources)) {
            return CommonPage.copyPageInfo(page, CollUtil.newArrayList());
        }
        List<BcxOrderRelation> result = transform2target(sources);
        return CommonPage.copyPageInfo(page, result);
    }

    private List<BcxOrderRelation> transform2target(List<BcxOrderRelation> sources) {
        List<BcxOrderRelation> result = new ArrayList<>();
        for (BcxOrderRelation source : sources) {
            BcxOrderRelation target = new BcxOrderRelation();
            BeanUtils.copyProperties(source, target);
            result.add(target);
        }
        return result;
    }

    @Override
    public Boolean create(BcxOrderRelation bcxOrderRelation) {
        return save(bcxOrderRelation);
    }

    public Boolean update(BcxOrderRelation bcxOrderRelation) {
        return updateById(bcxOrderRelation);
    }

    public Boolean delete(Integer id) {
        return removeById(id);
    }
}
