package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxBrokerageConfig;
import com.zbkj.common.request.*;
import com.zbkj.common.response.BcxBrokerageConfigResponse;
import com.zbkj.common.response.BcxBrokerageLoadResponse;
import com.zbkj.common.response.PlatformProductListResponse;

import java.util.List;

/**
 * description: 佣金绩效配置表 服务接口
 * author : linchunpeng
 * date : 2023/8/3
 */
public interface BcxBrokerageConfigService extends IService<BcxBrokerageConfig> {

    /**
     * description：查询佣金配置基础
     * author：linchunpeng
     * date：2023/8/7
     */
    BcxBrokerageLoadResponse load(BcxBrokerageLoadSearchRequest searchRequest);

    /**
     * description：查询佣金配置列表
     * author：linchunpeng
     * date：2023/8/7
     */
    List<BcxBrokerageConfigResponse> getList(BcxBrokerageConfigSearchRequest searchRequest);

    /**
     * description：佣金绩效配置信息保存
     * author：linchunpeng
     * date：2023/8/4
     */
    Boolean saveBcxBrokerageConfig(BcxBrokerageConfigRequest request);

    /**
     * description：设置商品是否开启分销
     * author：linchunpeng
     * date：2023/8/9
     */
    boolean setProductBrokerage(BcxSetProductBrokerageRequest request);

    /**
     * description：获取分销商品列表
     * author：linchunpeng
     * date：2023/8/9
     */
    PageInfo<PlatformProductListResponse> getProductList(ProductSearchRequest searchRequest, PageParamRequest pageParamRequest);
}