package com.zbkj.service.service;

import com.zbkj.common.dto.HuifuWalletTransferDto;
import org.springframework.scheduling.annotation.Async;

import java.math.BigDecimal;

public interface HuifuReconcileService {
    /**
     * 交易数据对账单下载、解压、解析、转换、保存
     * @param date
     */
    void reconcileOrder(String date,String huifuId);
    /**
     * 结算数据对账单下载、解压、解析、转换、保存
     * @param date
     */
    void reconcileSettle(String date,String huifuId);
    /**
     * 结算数据对账单下载、解压、解析、转换、保存   （用户结算）
     * @param date
     */
    void reconcileSettleuser(String date,String huifuId);
    /**
     * 出金数据对账单下载、解压、解析、转换、保存
     * @param date
     */
    void reconcileOutcash(String date,String huifuId);
    /**
     * 分账数据对账单下载、解压、解析、转换、保存
     * @param date
     */
    void reconcileSplit(String date,String huifuId);

    /**
     * <b> 异步执行平台分账 </b>
     * @author ZXF
     * @create 2023/09/15 0015 17:48
     * @version
     * @注意事项 </b>
     */
    void syncTransferToPlat(HuifuWalletTransferDto dto);

    /**
     * <b> 异步执行平台退款 </b>
     * @author ZXF
     * @create 2023/09/15 0015 17:48
     * @version
     * @注意事项 </b>
     */
    void syncRefundToPlat(HuifuWalletTransferDto dto);

    /**
     * 余额支付交易分账明细查询接口
     *
     * @param accountNo 发起方商户号
     * @param hfSeqId 全局流水号
     * @param tradeDate 交易日期
     * @return
     * @author lp
     * @date 2019-12-09
     */
    void payTradeDetailTask(String accountNo,String hfSeqId,String tradeDate);

    /**
     * <b> 异步执行冻结金额计算 </b>
     * @author ZXF
     * @create 2023/09/15 0015 17:48
     * @version
     * @注意事项 </b>
     */
    void syncUpdateSumFrozenAmount(String uniId, BigDecimal amount);
}
