package com.zbkj.service.huifu.v2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.request.V2UserBasicdataEntModifyRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.huifu.bspay.sdk.opps.core.utils.SequenceTools;
import com.zbkj.service.huifu.core.Identify;

import java.util.HashMap;
import java.util.Map;

/**
 * 企业用户基本信息修改 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2UserBasicdataEntModifyRequest.class)
public class V2UserBasicdataEntModify {

    public static V2UserBasicdataEntModifySubRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2UserBasicdataEntModifySubRequest request = JSONObject.parseObject(JSON.toJSONString(map),V2UserBasicdataEntModifySubRequest.class);
//        V2UserBasicdataEntModifyRequest request = new V2UserBasicdataEntModifyRequest();
        // 请求日期
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        // 请求流水号
        request.setReqSeqId(SequenceTools.getReqSeqId32());
        // 汇付客户Id
//        request.setHuifuId("6666000103862211");

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos(map);
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos(Map<String, Object> map) {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        // 企业用户名称
        extendInfoMap.put("reg_name", map.get("regName"));
        // 经营简称
        extendInfoMap.put("short_name", map.get("shortName"));
        // 营业执照编号
        extendInfoMap.put("license_code", map.get("licenseCode"));
        // 法人姓名
//        extendInfoMap.put("legal_name", "陈立健");
        // 法人证件类型
//        extendInfoMap.put("legal_cert_type", "00");
        // 法人证件号码
//        extendInfoMap.put("legal_cert_no", "370684198903061155");
        // 法人证件有效期类型
//        extendInfoMap.put("legal_cert_validity_type", "0");
        // 法人证件有效期开始日期
//        extendInfoMap.put("legal_cert_begin_date", "20121010");
        // 法人证件有效期截止日期
//        extendInfoMap.put("legal_cert_end_date", "20301010");
        // 联系人姓名
        extendInfoMap.put("contact_name", map.get("contactName"));
        // 联系人电子邮箱
//        extendInfoMap.put("contact_email", "chang@huifu.com");
        // 联系人手机号
        extendInfoMap.put("contact_mobile", map.get("contactMobile"));
        // 证照有效期类型
//        extendInfoMap.put("license_validity_type", "1");
        // 证照有效期起始日期
//        extendInfoMap.put("license_begin_date", "20200117");
        // 证照有效期结束日期
//        extendInfoMap.put("license_end_date", "20400117");
        // 注册地址(省)
        extendInfoMap.put("reg_prov_id", map.get("regProvId"));
        // 注册地址(市)
        extendInfoMap.put("reg_area_id", map.get("regAreaId"));
        // 注册地址(区)
        extendInfoMap.put("reg_district_id", map.get("regDistrictId"));
        // 注册地址(详细信息)
        extendInfoMap.put("reg_detail", map.get("regDetail"));
        // 文件列表
//        extendInfoMap.put("file_list", getFileList());
        return extendInfoMap;
    }

    private static String getFileList() {
        JSONObject dto = new JSONObject();
        // 文件类型
        dto.put("file_type", "F01");
        // 文件jfileID
        dto.put("file_id", "71da066c-5d15-3658-a86d-4e85ee67808a");
        // 文件名称
        dto.put("file_name", "企业营业执照1.jpg");

        JSONArray dtoList = new JSONArray();
        dtoList.add(dto);
        return dtoList.toJSONString();
    }

}
