package com.zbkj.service.huifu.v2;

import java.util.*;

import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONArray;
import com.huifu.bspay.sdk.opps.core.request.V2TradePaymentJspayRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.huifu.bspay.sdk.opps.core.utils.SequenceTools;
import com.zbkj.common.dto.AlipayData;
import com.zbkj.common.dto.Detail;
import com.zbkj.common.dto.GoodsDetail;
import com.zbkj.common.dto.WxData;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.service.huifu.constants.HFProfileConstants;
import com.zbkj.service.huifu.core.Identify;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * 聚合正扫接口 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2TradePaymentJspayRequest.class)
public class V2TradePaymentJspay {

    public static V2TradePaymentJspayRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2TradePaymentJspayRequest request = JSONObject.parseObject(JSON.toJSONString(map), V2TradePaymentJspayRequest.class);

        // 请求日期
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        // 请求流水号
        request.setReqSeqId(SequenceTools.getReqSeqId32());
        // 商户号
//        request.setHuifuId("6666000108854952");
        // 交易类型 T_MINIAPP: 微信小程序
        request.setTradeType("T_MINIAPP");
        // 交易金额
//        request.setTransAmt("0.10");
        // 商品描述
//        request.setGoodsDesc("hibs自动化-通用版验证");

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos(map);
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos(Map<String, Object> map) {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        // 交易有效期 5分钟
        extendInfoMap.put("time_expire", DateUtils.formatDate(DateUtils.addMinutes(new Date(),5),"yyyyMMddHHmmss"));
        // 禁用信用卡标记
        extendInfoMap.put("limit_pay_type", "NO_CREDIT");
        // 是否延迟交易
        extendInfoMap.put("delay_acct_flag", "N");
        // 渠道号
        extendInfoMap.put("channel_no", "");
        // 手续费扣款标志 1: 外扣 2: 内扣
//         extendInfoMap.put("fee_flag", "1");
        // 补贴支付信息
        // extendInfoMap.put("combinedpay_data", getCombinedpayData());
        // 场景类型
        extendInfoMap.put("pay_scene", "01");
        // 安全信息
        extendInfoMap.put("risk_check_data", getRiskCheckData());
        // 设备信息
//        extendInfoMap.put("terminal_device_data", getTerminalDeviceData());
        // 分账对象
        extendInfoMap.put("acct_split_bunch", getAcctSplitBunch(map));
        // 传入分帐遇到优惠的处理规则
        extendInfoMap.put("term_div_coupon_type", "0");
        // 聚合正扫微信拓展参数集合
         extendInfoMap.put("wx_data", getWxData(map));
        // 支付宝扩展参数集合
        extendInfoMap.put("alipay_data", getAlipayData(map));
        // 银联参数集合
        // extendInfoMap.put("unionpay_data", getUnionpayData());
        // 数字人民币参数集合
        // extendInfoMap.put("dc_data", getDcData());
        // 商户贴息标记
        extendInfoMap.put("fq_mer_discount_flag", "N");
        // 异步通知地址
        extendInfoMap.put("notify_url", map.get("notifyUrl"));
        // 备注
        extendInfoMap.put("remark", map.get("remark"));
        // 账户号
         extendInfoMap.put("acct_id", "");
        return extendInfoMap;
    }

    private static String getCombinedpayData() {
        JSONObject dto = new JSONObject();
        // 补贴方汇付编号
        // dto.put("huifu_id", "test");
        // 补贴方类型
        // dto.put("user_type", "test");
        // 补贴方账户号
        // dto.put("acct_id", "test");
        // 补贴金额
        // dto.put("amount", "test");

        JSONArray dtoList = new JSONArray();
        dtoList.add(dto);
        return dtoList.toJSONString();
    }

    private static String getRiskCheckData() {
        //客户IP获取
        String clientIP = "127.0.0.1";
        try{
            HttpServletRequest request = RequestUtil.getRequest();
            clientIP = ServletUtil.getClientIP(request, null);
        }catch (Exception e){}

        JSONObject dto = new JSONObject();
        // ip地址
        dto.put("ip_addr", clientIP);
        // 基站地址
        dto.put("base_station", "");
        // 纬度
        dto.put("latitude", "");
        // 经度
        dto.put("longitude", "");

        return dto.toJSONString();
    }

    private static String getTerminalDeviceData() {
        JSONObject dto = new JSONObject();
        // 商户设备类型
        // dto.put("mer_device_type", "test");
        // 汇付机具号
        dto.put("devs_id", "SPINTP357338300264411");
        // 设备类型
        dto.put("device_type", "1");
        // 交易设备IP
        dto.put("device_ip", "10.10.0.1");
        // 交易设备MAC
        dto.put("device_mac", "");
        // 交易设备IMEI
        dto.put("device_imei", "");
        // 交易设备IMSI
        dto.put("device_imsi", "");
        // 交易设备ICCID
        dto.put("device_icc_id", "");
        // 交易设备WIFIMAC
        dto.put("device_wifi_mac", "");
        // 交易设备GPS
        dto.put("device_gps", "192.168.0.0");
        // 商户终端应用程序版本
        // dto.put("app_version", "");
        // SIM 卡卡号
        // dto.put("icc_id", "");
        // 商户终端实时经纬度信息
        // dto.put("location", "");
        // 商户交易设备IP
        // dto.put("mer_device_ip", "");
        // 移动国家代码
        // dto.put("mobile_country_cd", "");
        // 移动网络号码
        // dto.put("mobile_net_num", "");
        // 商户终端入网认证编号
        // dto.put("network_license", "");
        // 商户终端序列号
        // dto.put("serial_num", "");

        return dto.toJSONString();
    }

    private static JSON getAcctInfosRucan(Map<String, Object> map) {
        JSONArray dtoList = new JSONArray();
        JSONObject dto = new JSONObject();

        // 手续费
        dto.put("div_amt", map.get("commissionAmount"));
        // 被分账方ID 主商户
        dto.put("huifu_id", map.get("huifuId"));
        dtoList.add(dto);

        JSONObject dto1 = new JSONObject();
        // 分账金额
        dto1.put("div_amt", map.get("inAmount"));
        // 被分账方ID
        dto1.put("huifu_id", map.get("inWalletAccountNo"));
        dtoList.add(dto1);
        //平台分账
        /*if("1".equals(map.get("isPlatAcct"))){
            JSONObject dto2 = new JSONObject();
            // 分账金额
            dto2.put("div_amt", map.get("platAmount"));
            // 被分账方ID
            dto2.put("huifu_id", HFProfileConstants.HUIFU_ID);
            // 被分账方账户号
            // dto2.put("acct_id", "");

        }*/
        return dtoList;
    }

    private static String getAcctSplitBunch(Map<String, Object> map) {
        JSONObject dto = new JSONObject();
        // 分账明细
         dto.put("acct_infos", getAcctInfosRucan(map));

        return dto.toJSONString();
    }

    private static JSON getGoodsDetailWxRucan(List<GoodsDetail> goods_detail) {
        JSONArray dtoList = new JSONArray();
        for (GoodsDetail detail:goods_detail) {
            JSONObject dto = new JSONObject();
            // 商品的编号
            dto.put("goods_id", detail.getGoods_id());
            // 商品名称(元)
            dto.put("goods_name", detail.getGoods_name());
            // 商品单价
            dto.put("price", detail.getPrice());
            // 商品数量
            dto.put("quantity", detail.getQuantity());
            // 微信侧商品编码
            // dto.put("wxpay_goods_id", "");
            dtoList.add(dto);
        }
        return dtoList;
    }

    private static JSON getDetail(Detail detail) {
        JSONObject dto = new JSONObject();
        // 单品列表
         dto.put("goods_detail", getGoodsDetailWxRucan(detail.getGoods_detail()));
        // 订单原价(元)
         dto.put("cost_price", detail.getCost_price());
        // 商品小票ID
        // dto.put("receipt_id", "");

        return dto;
    }

    private static JSON getStoreInfo() {
        JSONObject dto = new JSONObject();
        // 门店id
        // dto.put("id", "");
        // 门店名称
        // dto.put("name", "");
        // 门店行政区划码
        // dto.put("area_code", "");
        // 门店详细地址
        // dto.put("address", "");

        JSONArray dtoList = new JSONArray();
        dtoList.add(dto);
        return dtoList;
    }

    private static JSON getSceneInfo() {
        JSONObject dto = new JSONObject();
        // 门店信息
        // dto.put("store_info", getStoreInfo());

        return dto;
    }

    private static String getWxData(Map<String, Object> map) {
        WxData wxData = StringUtils.isNotEmpty(map.get("wxData")+"")?JSONObject.parseObject(map.get("wxData")+"", WxData.class):null;
        JSONObject dto = new JSONObject();
        // 子商户公众账号id
         dto.put("sub_appid", wxData.getSub_appid());
        // 用户标识
         dto.put("openid", wxData.getOpenid());
        // 子商户用户标识
         dto.put("sub_openid", wxData.getSub_openid());
        // 附加数据
         dto.put("attach", "");
        // 商品描述
         dto.put("body", wxData.getBody());
        // 商品详情
         dto.put("detail", getDetail(wxData.getDetail()));
        // 设备号
//         dto.put("device_info", "");
        // 订单优惠标记
//         dto.put("goods_tag", "");
        // 实名支付
//         dto.put("identity", "");
        // 开发票入口开放标识
//         dto.put("receipt", "");
        // 场景信息
//         dto.put("scene_info", getSceneInfo());
        // 终端ip
//         dto.put("spbill_create_ip", "");

        return dto.toJSONString();
    }

    private static JSON getExtendParams() {
        JSONObject dto = new JSONObject();
        // 卡类型
        dto.put("card_type", "");
        // 支付宝点餐场景类型
        dto.put("food_order_type", "qr_order");
        // 花呗分期数
        dto.put("hb_fq_num", "");
        // 花呗卖家承担的手续费百分比
        dto.put("hb_fq_seller_percent", "");
        // 行业数据回流信息
        dto.put("industry_reflux_info", "string");
        // 停车场id
        dto.put("parking_id", "123wsx");
        // 系统商编号
        dto.put("sys_service_provider_id", "1111111");
        // 信用卡分期资产方式
        // dto.put("fq_channels", "");

        return dto;
    }

    private static JSON getGoodsDetail(List<GoodsDetail> goods_detail) {
        JSONArray dtoList = new JSONArray();
        for (GoodsDetail detail:goods_detail) {
            JSONObject dto = new JSONObject();
            // 商品的编号
            dto.put("goods_id", detail.getGoods_id());
            // 商品名称(元)
            dto.put("goods_name", detail.getGoods_name());
            // 商品单价
            dto.put("price", detail.getPrice());
            // 商品数量
            dto.put("quantity", detail.getQuantity());
            // 商品描述信息
            dto.put("body", "");
            // 商品类目树
            dto.put("categories_tree", "");
            // 商品类目
            dto.put("goods_category", "");
            // 商品的展示地址
            dto.put("show_url", "");
            dtoList.add(dto);
        }
        return dtoList;
    }

    private static String getAlipayData(Map<String, Object> map) {
        AlipayData alipayData = StringUtils.isNotEmpty(map.get("alipayData")+"")?JSONObject.parseObject(map.get("alipayData")+"", AlipayData.class):null;
        JSONObject dto = new JSONObject();
        if(alipayData!=null){

            // 买家的支付宝唯一用户号
            dto.put("buyer_id", "");
            // 支付宝的店铺编号
            dto.put("alipay_store_id", "");
            // 买家支付宝账号
            dto.put("buyer_logon_id", alipayData.getBuyer_logon_id());
            // 业务扩展参数
//            dto.put("extend_params", getExtendParams());
            // 订单包含的商品列表信息
            dto.put("goods_detail", getGoodsDetail(alipayData.getGoods_detail()));
            // 商户原始订单号
            dto.put("merchant_order_no", "");
            // 商户操作员编号
            dto.put("operator_id", "");
            // 销售产品码
            dto.put("product_code", "");
            // 卖家支付宝用户号
            dto.put("seller_id", "");
            // 商户门店编号
            dto.put("store_id", "");
        }

        return dto.toJSONString();
    }

    private static JSON getPayeeInfo() {
        JSONObject dto = new JSONObject();
        // 商户类别
        // dto.put("mer_cat_code", "");
        // 二级商户代码
        // dto.put("sub_id", "");
        // 二级商户名称
        // dto.put("sub_name", "");
        // 终端号
        // dto.put("term_id", "");

        return dto;
    }

    private static String getUnionpayData() {
        JSONObject dto = new JSONObject();
        // 收款方附加数据
        // dto.put("acq_addn_data", "");
        // 地区信息
        // dto.put("area_info", "");
        // 持卡人ip
        // dto.put("customer_ip", "");
        // 前台通知地址
        // dto.put("front_url", "");
        // 订单描述
        // dto.put("order_desc", "");
        // 收款方附言
        // dto.put("payee_comments", "");
        // 收款方信息
        // dto.put("payee_info", getPayeeInfo());
        // 银联分配的服务商机构标识码
        // dto.put("pnr_ins_id_cd", "");
        // 请求方自定义域
        // dto.put("req_reserved", "");
        // 终端信息
        // dto.put("term_info", "");
        // 云闪付用户标识
        // dto.put("user_id", "");

        return dto.toJSONString();
    }

    private static String getDcData() {
        JSONObject dto = new JSONObject();
        // 数字货币银行编号
        // dto.put("digital_bank_no", "");

        return dto.toJSONString();
    }

}
