package com.zbkj.common.response.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.HorizontalAlignmentEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 订单发票明细导出对象
 */
@Data
public class BcxOrderFapiaoExcelDto implements Serializable {

    @ExcelProperty(value = "流水号", order = 10)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String applyNo;

    @ExcelProperty(value = "用户名称", order = 12)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String userName;

    @ExcelProperty(value = "商品类型", order = 14)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String bizTypeName;

    public String getBizTypeName() {
        if (bizType == 0) return "实体商品";
        if (bizType == 1) return "虚拟商品";
        if (bizType == 2) return "特殊(考培)商品";
        if (bizType == 3) return "保险商品";
        if (bizType == 4) return "风评商品";
        return "未知";
    }

    @ExcelIgnore
    private Integer bizType;

    @ExcelProperty(value = "商品信息", order = 16)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String productInfo;

    @ExcelProperty(value = "发票金额", order = 18)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private BigDecimal amount;

    @ExcelProperty(value = "关联订单号", order = 20)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String orderNo;

    @ExcelProperty(value = "发票类型", order = 22)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String fapiaoTypeName;

    public String getFapiaoTypeName() {
        if (fapiaoType == 0) return "增值税普通";
        if (fapiaoType == 1) return "增值税专用";
        return "未知";
    }

    @ExcelIgnore
    private Integer fapiaoType;

    @ExcelProperty(value = "税号", order = 24)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String taxNo;

    @ExcelProperty(value = "开户银行", order = 26)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String bankName;

    @ExcelProperty(value = "银行账号", order = 28)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String bankAccount;

    @ExcelProperty(value = "企业地址", order = 30)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String address;

    @ExcelProperty(value = "企业电话", order = 32)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String phone;

    @ExcelProperty(value = "抬头类型", order = 34)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String titleTypeName;

    public String getTitleTypeName() {
        if (titleType == 0) return "个人";
        if (titleType == 1) return "企业";
        return "未知";
    }

    @ExcelIgnore
    private Integer titleType;

    @ExcelProperty(value = "发票抬头", order = 36)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String title;

    @ExcelProperty(value = "邮箱", order = 38)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String email;

    @ExcelProperty(value = "开票状态", order = 40)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String fapiaoStatusName;

    public String getFapiaoStatusName() {
        if (fapiaoStatus == 0) return "未开票";
        if (fapiaoStatus == 1) return "已开发票";
        return "未知";
    }

    @ExcelIgnore
    private Integer fapiaoStatus;

    @ExcelProperty(value = "备注", order = 42)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String remark;
}
