package com.zbkj.common.response.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 发票源单据响应对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxFapiaoSourceResponse对象", description = "发票源单据响应对象")
public class BcxFapiaoSourceResponse implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "源单id")
    private Integer id;

    @ApiModelProperty(value = "源单号")
    private String sourceNo;

    @ApiModelProperty(value = "0-商品购买 1-平台服务费2-渠道服务费 3-分销服务费")
    private Integer sourceType;

    @ApiModelProperty(value = "开票方id")
    private Integer writerId;

    @ApiModelProperty(value = "开票方")
    private String writer;

    @ApiModelProperty(value = "收票方id")
    private Integer receiverId;

    @ApiModelProperty(value = "收票方")
    private String receiver;

    @ApiModelProperty(value = "商品名称")
    private String productInfo;

    @ApiModelProperty(value = "商品三级分类id")
    private Integer categoryId;

    @ApiModelProperty(value = "商品分类")
    private String categoryName;

    @ApiModelProperty(value = "生成时间")
    private Date sourceTime;

    @ApiModelProperty(value = "数量")
    private Integer quantity;

    @ApiModelProperty(value = "单价")
    private BigDecimal price;

    @ApiModelProperty(value = "金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "关联申请单")
    private String applyNo;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "发票号")
    private String fapiaoNo;

    @ApiModelProperty(value = "开票时间")
    private Date writeTime;

    @ApiModelProperty(value = "状态 0-未开票 1-已开票 2-开票中 3-开票失败")
    private Integer fapiaoStatus;

    @ApiModelProperty(value = "0-增值税普通 1-增值税专用")
    private Integer fapiaoType;

    @ApiModelProperty(value = "发票金额")
    private BigDecimal fapiaoAmount;
}
