package com.zbkj.common.response.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 最后一次收票人信息返回对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxFapiaoLastSendToResponse对象", description = "最后一次收票人信息返回对象")
public class BcxFapiaoLastSendToResponse implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "收票人名称")
    private String sendToName;

    @ApiModelProperty(value = "收票人电话")
    private String sendToPhone;

    @ApiModelProperty(value = "收票人email")
    private String sendToEmail;

    @ApiModelProperty(value = "收票人地址")
    private String sendToAddress;
}
