package com.zbkj.common.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * description: 佣金配置 response对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxBrokerageConfigResponse对象", description = "佣金配置 response对象")
public class BcxBrokerageConfigResponse implements Serializable {

    @ApiModelProperty(value = "配置id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "商品id")
    private Integer productId;

    @ApiModelProperty(value = "渠道/部门/部门成员 id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long belongId;

    @ApiModelProperty(value = "部门成员-v5-ID")
    private String bcxId;

    @ApiModelProperty(value = "渠道名称/部门名称/部门成员")
    private String name;

    @ApiModelProperty(value = "渠道类型：1业务渠道，2区域渠道")
    private Integer channelType;

    @ApiModelProperty(value = "佣金类型：1比例，2固定，3自留")
    private Integer type;

    @ApiModelProperty(value = "佣金比例")
    private BigDecimal ratio;

    @ApiModelProperty(value = "服务佣金")
    private BigDecimal serviceRatio;

    @ApiModelProperty(value = "计算系数，默认100%")
    private BigDecimal calculateRatio;
    
    @ApiModelProperty(value = "关联区域")
    private List<BcxRegionResponse> regionList;


}