package com.zbkj.common.request.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 平台服务费-配置Request对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxPlatformFeeConfigRequest对象", description = "平台服务费-配置Request对象")
public class BcxPlatformFeeConfigRequest implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "平台服务费配置id")
    private Integer id;

    @ApiModelProperty(value = "0-平台 1-商户 3-商品 4-sku，新增时会自动计算")
    private Integer level;

    @ApiModelProperty(value = "商户id, 给商户配置默认分账时必填")
    private Integer merId;

    @ApiModelProperty(value = "商品id, 给商品配置默认分账时必填")
    private Integer productId;

    @ApiModelProperty(value = "sku id")
    private Integer skuId;

    @ApiModelProperty(value = "售卖服务费类型：0-百分比 1-金额")
    private Integer sellFeeType;

    @ApiModelProperty(value = "售卖服务费")
    private BigDecimal sellFee;

    @ApiModelProperty(value = "销售分账优先级 0-平台 1-商户")
    private Integer sellFeePriority;

    @ApiModelProperty(value = "租赁服务费类型：0-百分比 1-金额")
    private Integer leaseFeeType;

    @ApiModelProperty(value = "租赁服务费")
    private BigDecimal leaseFee;

    @ApiModelProperty(value = "赁分账优先级 0-平台 1-商户")
    private Integer leaseFeePriority;

    @ApiModelProperty(value = "分期分账优先级 0-平台 1-商户")
    private Integer instalmentFeePriority;

    @ApiModelProperty(value = "分期服务费类型：0-百分比 1-金额")
    private Integer instalmentFeeType;

    @ApiModelProperty(value = "分期3期 服务费")
    private BigDecimal period3Fee;

    @ApiModelProperty(value = "分期6期 服务费")
    private BigDecimal period6Fee;

    @ApiModelProperty(value = "分期9期 服务费")
    private BigDecimal period9Fee;

    @ApiModelProperty(value = "分期12期 服务费")
    private BigDecimal period12Fee;
}
