package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 保险订单请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="InsuranceOrderRequest对象", description="保险订单请求对象")
public class InsuranceOrderRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "商品编码/对应商城商品规格中的商品条码", required = true)
    @NotBlank(message = "商品编码不能为空")
    private String productCode;

    @ApiModelProperty(value = "购买数量", required = true)
    private Integer payNum;

    @ApiModelProperty(value = "实际支付金额", required = true)
    private BigDecimal payPrice;

    @ApiModelProperty(value = "投保人身份证号", required = true)
    @NotBlank(message = "投保人身份证号不能为空")
    private String socialNum;
}
