package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * description：用户新增绑定银行卡请求对象
 * author：linchunpeng
 * date：2023/11/1
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxUserAddBankCardRequest对象", description = "用户新增绑定银行卡请求对象")
public class BcxUserAddBankCardRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "姓名")
    @NotBlank(message = "姓名不能为空")
    private String userName;

    @ApiModelProperty(value = "银行编号")
    @NotNull(message = "银行编号不能为空")
    private Long bankCode;

    @ApiModelProperty(value = "银行名称")
    @NotBlank(message = "银行名称不能为空")
    private String bankName;

    @ApiModelProperty(value = "支行联行编号")
    @NotNull(message = "支行联行编号不能为空")
    private Long branchCode;

    @ApiModelProperty(value = "支行名称")
    @NotBlank(message = "支行名称不能为空")
    private String branchName;

    @ApiModelProperty(value = "银行卡号")
    @NotBlank(message = "银行卡号不能为空")
    private String bankCardNo;

    @ApiModelProperty(value = "是否默认银行卡：0否，1是")
    @NotNull(message = "是否默认银行卡不能为空")
    private Integer isDefault;

}
