package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * description：结算request对象
 * author：linchunpeng
 * date：2023/8/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxDoSettleRequest对象", description = "结算request对象")
public class BcxDoSettleRequest {

    @ApiModelProperty(value = "结算单id列表")
    @NotEmpty(message = "结算单id列表不能为空")
    private List<Long> settleIdList;

    @ApiModelProperty(value = "支付方式：1线下结算，2企业钱包结算，3第三方支付结算")
    private Integer payWay;

}
