package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

/**
 * description：佣金配置查询request对象
 * author：linchunpeng
 * date：2023/8/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxBrokerageConfigSearchRequest对象", description = "佣金配置查询request对象")
public class BcxBrokerageConfigSearchRequest {

    @ApiModelProperty(value = "商品id（有传就是查询商品，没传就是查询默认配置）")
    private Integer productId;

    @ApiModelProperty(value = "关联类型：1渠道表，2部门表，3部门成员表")
    @NotNull(message = "关联类型 不能为空")
    private Integer belongType;

    @ApiModelProperty(value = "区域编码")
    private String regionCode;

    public BcxBrokerageConfigSearchRequest() {
    }

    public BcxBrokerageConfigSearchRequest(Integer productId, Integer belongType, String regionCode) {
        this.productId = productId;
        this.belongType = belongType;
        this.regionCode = regionCode;
    }
}
