package com.zbkj.common.model.huifu;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <b> 企业钱包账户收支明细 </b>
 * @author ZXF
 * @create 2023/07/26 0026 16:48
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_huifu_wallet_account_detail")
@ApiModel(value="HuifuWalletAccountDetail对象", description="企业钱包账户收支明细")
public class HuifuWalletAccountDetail implements Serializable {

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty(value = "用户联合ID")
    private String uniId;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "交易时间")
    private String tradeDate;
    @ApiModelProperty(value = "交易流水号")
    private String tradeFlowNo;
    @ApiModelProperty(value = "账务流水号（业务流水号）")
    private String flowNo;
    @ApiModelProperty(value = "账务处理类型")
    private String accountsDealType;
    @ApiModelProperty(value = "账务处理时间")
    private String accountsDealDate;
    @ApiModelProperty(value = "交易金额")
    private String amount;
    @ApiModelProperty(value = "交易后余额")
    private String balance;
    @ApiModelProperty(value = "资金流向")
    private String direction;
    @ApiModelProperty(value = "处理状态")
    private String handStatus;
    @ApiModelProperty(value = "订单创建时间")
    private String createDate;
    @ApiModelProperty(value = "服务类型")
    private String serviceType;
    @ApiModelProperty(value = "交易类型")
    private String tradeType;
    @ApiModelProperty(value = "收款方账户")
    private String accountIn;
    @ApiModelProperty(value = "付款方账户")
    private String accountOut;
    @ApiModelProperty(value = "收款方账户中文")
    private String accountInName;
    @ApiModelProperty(value = "付款方账户中文")
    private String accountOutName;
    @ApiModelProperty(value = "备注")
    private String memo;
    @ApiModelProperty(value = "电子回单url")
    private String voucherUrl;

    public String getAmount() {
//        return new DecimalFormat("#,##0.00").format(new Double(amount));
        return amount;
    }

//    public String getBalance() {
//        return new DecimalFormat("#,##0.00").format(new Double(balance));
//    }
}