package com.zbkj.common.model.huifu;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 银行配置表
 * </p>
 *
 * @author HZW
 * @since 2022-08-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_bank_config")
@ApiModel(value = "BankConfig对象", description = "银行配置表")
public class BankConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "支行联行号")
    private Long branchCode;

    @ApiModelProperty(value = "银行号")
    private String bankCode;

    @ApiModelProperty(value = "银行名称")
    private String bankName;

    @ApiModelProperty(value = "支行名称")
    private String branchName;

}
