package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * 用户企业认证表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_user_org_auth")
@ApiModel(value = "BcxUserOrgAuth对象", description = "用户企业认证表")
public class BcxUserOrgAuth implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "用户企业认证表id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "用户id")
    private Integer uid;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "身份证号")
    private String idCardNo;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "验证码")
    private String authCode;

    @ApiModelProperty(value = "企业名称")
    private String orgName;

    @ApiModelProperty(value = "法人")
    private String legalPerson;

    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @ApiModelProperty(value = "注册地")
    private String regAddress;

    @ApiModelProperty(value = "详细地址")
    private String address;
}
