package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * description: 业绩账单表
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_settle_bill")
@ApiModel(value = "BcxSettleBill对象", description = "业绩账单表")
public class BcxSettleBill implements Serializable {
    
    @ApiModelProperty(value = "主键id")
    @TableId(value = "id")
    private Long id;
    
    @ApiModelProperty(value = "关联id：渠道表id，部门表id，部门成员表id，用户表id")
    private Long belongId;
    
    @ApiModelProperty(value = "关联类型：1渠道表，2部门表，3部门成员表，4用户表-分销商，5用户表-分销员")
    private Integer belongType;

    @ApiModelProperty(value = "账期，yyyy-MM")
    private String billPeriod;
    
    @ApiModelProperty(value = "订单总数量")
    private Integer orderCount;
    
    @ApiModelProperty(value = "订单总金额")
    private BigDecimal orderTotalPrice;
    
    @ApiModelProperty(value = "佣金总金额")
    private BigDecimal brokerageTotalPrice;
    
    @ApiModelProperty(value = "佣金已结算总金额")
    private BigDecimal brokerageSettleTotalPrice;
    
    @ApiModelProperty(value = "结算状态：1待结算，2部分结算，3已结算")
    private Integer settleStatus;
    
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    

}