package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * description: v5区域表
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_region")
@ApiModel(value = "BcxRegion对象", description = "v5区域表")
public class BcxRegion implements Serializable {
    
    @ApiModelProperty(value = "主键id")
    @TableId(value = "id")
    private Long id;
    
    @ApiModelProperty(value = "区域code")
    private String regionCode;
    
    @ApiModelProperty(value = "区域名称")
    private String regionName;
    
    @ApiModelProperty(value = "区域全称")
    private String regionFullName;
    
    @ApiModelProperty(value = "区域级别")
    private Integer regionLevel;

    @ApiModelProperty(value = "排序")
    private Integer seq;

    @ApiModelProperty(value = "上级区域code")
    private String parentCode;
    

}