package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * description: 业绩报表
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_performance_report")
@ApiModel(value = "BcxPerformanceReport对象", description = "业绩报表")
public class BcxPerformanceReport implements Serializable {
    
    @ApiModelProperty(value = "主键id")
    @TableId(value = "id")
    private Long id;

    @ApiModelProperty(value = "关联id：渠道表id，部门表id，部门成员表id，用户表id")
    private Long belongId;

    @ApiModelProperty(value = "关联类型：1渠道表，2部门表，3部门成员表，4用户表-分销商，5用户表-分销员")
    private Integer belongType;

    @ApiModelProperty(value = "订单id")
    private Integer orderId;

    @ApiModelProperty(value = "订单号")
    private String orderNo;
    
    @ApiModelProperty(value = "下单用户id")
    private Integer orderUserId;
    
    @ApiModelProperty(value = "下单时间")
    private Date orderTime;

    @ApiModelProperty(value = "订单明细id")
    private Integer orderDetailId;

    @ApiModelProperty(value = "商品id")
    private Integer productId;
    
    @ApiModelProperty(value = "商品名称")
    private String productName;
    
    @ApiModelProperty(value = "商品规格值id")
    private Integer attrValueId;

    @ApiModelProperty(value = "商品sku")
    private String sku;

    @ApiModelProperty(value = "退款订单id")
    private Integer refundOrderId;

    @ApiModelProperty(value = "退款订单号")
    private String refundOrderNo;

    @ApiModelProperty(value = "退款订单明细id")
    private Integer refundOrderInfoId;

    @ApiModelProperty(value = "实际支付金额")
    private BigDecimal payPrice;

    @ApiModelProperty(value = "实际业务量，计算公式：实际支付金额 * 计算系数")
    private BigDecimal payPriceCalculate;

    @ApiModelProperty(value = "佣金配置类型：1默认比例，2自定义比例")
    private Integer brokerageConfigType;

    @ApiModelProperty(value = "佣金配置快照")
    private String brokerageConfigSnapshot;

    @ApiModelProperty(value = "佣金类型：1比例，2固定，3自留")
    private Integer brokerageType;

    @ApiModelProperty(value = "是否服务绩效：1是，0否")
    private Integer isServe;

    @ApiModelProperty(value = "佣金比例")
    private BigDecimal brokerageRatio;

    @ApiModelProperty(value = "计算系数")
    private BigDecimal brokerageCalculateRatio;

    @ApiModelProperty(value = "佣金金额")
    private BigDecimal brokeragePrice;

    @ApiModelProperty(value = "能退款的佣金余额")
    private BigDecimal canRefundPrice;

    @ApiModelProperty(value = "解冻时间")
    private Date unFreezeTime;

    @ApiModelProperty(value = "分账状态：1已分账，0未分账")
    private Integer separateAccountStatus;

    @ApiModelProperty(value = "结算时间")
    private Date settleTime;

    @ApiModelProperty(value = "结算状态：1待生效，2冻结中，3待结算，4结算中，5已结算，6无效")
    private Integer settleStatus;

    @ApiModelProperty(value = "支付方式：1线下结算，2企业钱包结算，3第三方支付结算")
    private Integer payWay;

    @ApiModelProperty(value = "所属账单id")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Long settleBillId;

    @ApiModelProperty(value = "结算id")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Long settleId;

    @ApiModelProperty(value = "结算凭证id")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Long settleAttachmentsId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

}