package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.Email;
import java.io.Serializable;
import java.util.Date;

/**
 * 发票抬头表
 *
 * invoice/bill/check是支付前的凭证，
 * receipt/ticket 是付款过的凭证，非税务局核发
 * 只有fapiao才可以用于报销
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_fapiao_title")
@ApiModel(value = "BcxFapiaoTitle对象", description = "发票抬头表")
public class BcxFapiaoTitle implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "发票抬头id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "用户id")
    private Integer uid;

    @ApiModelProperty(value = "0-个人 1-企业", required = true)
    private Integer titleType;

    @ApiModelProperty(value = "0-增值税普通 1-增值税专用", required = true)
    private Integer fapiaoType;

    @ApiModelProperty(value = "发票抬头", required = true)
    private String title;

    @ApiModelProperty(value = "税号")
    private String taxNo;

    @ApiModelProperty(value = "邮箱")
    @Email
    private String email;

    @ApiModelProperty(value = "开户银行")
    private String bankName;

    @ApiModelProperty(value = "银行账号")
    private String bankAccount;

    @ApiModelProperty(value = "企业地址")
    private String address;

    @ApiModelProperty(value = "企业电话")
    private String phone;

    @ApiModelProperty(value = "0-否 1-默认抬头")
    private Boolean isDefault;
}
