package com.zbkj.common.enums;

/**
 * description：分销订单类型，0：无分销（没有一级、二级）  1：普通分销  2：业务渠道分销  3：区域渠道分销  4：部门成员分销
 * author：linchunpeng
 * date：2023/10/25
 */
public enum BrokerageOrderTypeEnum {

    NOTHING("无分销", 0),
    NORMAL("普通分销", 1),
    BUSINESS_CHANNEL("业务渠道分销", 2),
    REGION_CHANNEL("区域渠道分销", 3),
    DEPARTMENT_MEMBER("部门成员分销", 4);

    private final String name;
    private final Integer value;

    BrokerageOrderTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }

}
