package com.zbkj.common.enums;

/**
 * description：业绩报表结算状态：1待生效，2冻结中，3待结算，4结算中，5已结算，6无效
 * author：linchunpeng
 * date：2023/8/4
 */
public enum BcxReportSettleStatusEnum {

    WAIT_EFFECTIVE("待生效", 1),
    FROZEN("冻结中", 2),
    WAIT_SETTLED("待结算", 3),
    SETTLING("结算中", 4),
    SETTLED("已结算", 5),
    INVALID("无效", 6);

    private final String name;
    private final Integer value;

    BcxReportSettleStatusEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }


    public static BcxReportSettleStatusEnum getInstance(int value) {
        switch (value) {
            case 1:
                return WAIT_EFFECTIVE;
            case 2:
                return FROZEN;
            case 3:
                return WAIT_SETTLED;
            case 4:
                return SETTLING;
            case 5:
                return SETTLED;
            case 6:
                return INVALID;
        }
        return null;
    }
}
