package com.zbkj.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 汇付C端聚合正扫微信配置
 *
 * @author Administrator
 * @create 2023-08-25 15:24
 */
@Data
public class WxData implements Serializable {
    @ApiModelProperty(value = "微信分配的子商户公众账号id，微信js/小程序支付必传")
    private String sub_appid;
    @ApiModelProperty(value = "在商户appid下的唯一标志")
    private String openid;
    @ApiModelProperty(value = "微信js/小程序支付必传")
    private String sub_openid;
    @ApiModelProperty(value = "在查询api和支付通知中原样返回，该字段主要用于商户携带订单的自定义数据")
    private String attach;
    @ApiModelProperty(value = "商品描述")
    private String body;
    @ApiModelProperty(value = "商品详情")
    private Detail detail;

}
