package com.zbkj.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;


/**
 * <b> 商户消费分账 </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:21
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="HuifuWalletConsumeLedgerDto", description="商户消费分账")
public class HuifuWalletConsumeLedgerDto implements Serializable {

    @ApiModelProperty(value = "出账方")
    private Integer outId;

    @ApiModelProperty(value = "订单金额")
    private String amount;

    @ApiModelProperty(value = "手机号")
    private String contactPhone;

    @ApiModelProperty(value = "验证码")
    private String activeCode;

    @ApiModelProperty(value = "分账信息")
    private List<LedgerInfo> ledgerInfoList;

    @Data
    public static class LedgerInfo {

        @ApiModelProperty(value = "分账方UId")
        private Integer inId;

        @ApiModelProperty(value = "分账金额")
        private String amount;

    }
}
