/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.community.CommunityAuthorConcerned;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.service.dao.community.CommunityAuthorConcernedDao;
import com.zbkj.service.service.CommunityAuthorConcernedService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CommunityAuthorConcernedServiceImpl
extends ServiceImpl<CommunityAuthorConcernedDao, CommunityAuthorConcerned>
implements CommunityAuthorConcernedService {
    @Resource
    private CommunityAuthorConcernedDao dao;

    @Override
    public List<Integer> findAuthorIdList(Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityAuthorConcerned::getAuthorId});
        lqw.eq(CommunityAuthorConcerned::getUid, (Object)userId);
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return new ArrayList<Integer>();
        }
        return list.stream().map(CommunityAuthorConcerned::getAuthorId).collect(Collectors.toList());
    }

    @Override
    public Boolean isConcernedByUid(Integer authorId, Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityAuthorConcerned::getId});
        lqw.eq(CommunityAuthorConcerned::getAuthorId, (Object)authorId);
        lqw.eq(CommunityAuthorConcerned::getUid, (Object)userId);
        CommunityAuthorConcerned concerned = (CommunityAuthorConcerned)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)concerned) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Integer getCountByAuthorId(Integer authorId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityAuthorConcerned::getId});
        lqw.eq(CommunityAuthorConcerned::getAuthorId, (Object)authorId);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Integer getCountByUserId(Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityAuthorConcerned::getId});
        lqw.eq(CommunityAuthorConcerned::getUid, (Object)userId);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public PageInfo<CommunityAuthorConcerned> findPage(Integer authorId, Integer userId, PageParamRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (authorId > 0) {
            lqw.eq(CommunityAuthorConcerned::getAuthorId, (Object)authorId);
        }
        if (userId > 0) {
            lqw.eq(CommunityAuthorConcerned::getUid, (Object)userId);
        }
        lqw.orderByDesc(CommunityAuthorConcerned::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public void concernedAuthor(Integer authorId, Integer userId) {
        if (authorId.equals(userId)) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u4e0d\u652f\u6301\u5173\u6ce8\u81ea\u5df1"));
        }
        CommunityAuthorConcerned concerned = this.getDetail(authorId, userId);
        if (ObjectUtil.isNotNull((Object)concerned)) {
            boolean remove = this.removeById((Serializable)concerned);
            if (!remove) {
                throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u793e\u533a\u53d6\u5173\u4f5c\u8005\u5931\u8d25"));
            }
            return;
        }
        concerned = new CommunityAuthorConcerned();
        concerned.setAuthorId(authorId);
        concerned.setUid(userId);
        boolean save = this.save(concerned);
        if (!save) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u5173\u6ce8\u4f5c\u8005\u5931\u8d25"));
        }
    }

    private CommunityAuthorConcerned getDetail(Integer authorId, Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CommunityAuthorConcerned::getAuthorId, (Object)authorId);
        lqw.eq(CommunityAuthorConcerned::getUid, (Object)userId);
        lqw.last(" limit 1");
        return (CommunityAuthorConcerned)this.dao.selectOne((Wrapper)lqw);
    }
}

