package com.zbkj.admin.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;

import com.crmeb.encrypt.Encrypt;
import com.zbkj.admin.copyright.CopyrightInfoResponse;
import com.zbkj.admin.copyright.CopyrightUpdateInfoRequest;
import com.zbkj.admin.service.CopyrightService;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.SysConfigConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;

/**
 * 版权服务实现类
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
@Service
public class CopyrightServiceImpl implements CopyrightService {

    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private SystemAttachmentService systemAttachmentService;

    /**
     * 获取版权信息
     */
    @Override
    public CopyrightInfoResponse getInfo() {
        CopyrightInfoResponse response = new CopyrightInfoResponse();
        String domainName = systemConfigService.getValueByKey(SysConfigConstants.CONFIG_KEY_API_URL);
        if (StrUtil.isBlank(domainName)) {
            response.setStatus(-2);
            return response;
        }
        String label = systemConfigService.getValueByKey(SysConfigConstants.CONFIG_COPYRIGHT_LABEL);
        String version = crmebConfig.getVersion();
        if (StrUtil.isBlank(version)) {
            throw new CrmebException("请先在yml中配置版本号");
        }
        response.setDomainUrl(domainName);
        response.setLabel(Integer.parseInt(label));
        response.setVersion(version);

//        JSONObject jsonObject = restTemplateUtil.post(StrUtil.format(Encrypt.CRMEB_COPYRIGHT_URL, domainName, label, version));
        String staticCopyright = "{\"msg\":\"ok\",\"data\":{\"status\":1,\"copyright\":\"copyrightZC5462297\",\"auto_content\":\"SevmYAiFCsF4wVyDWlS4Ml7FXqUvoiBUEd94xtFSYd+PLOJpsuIZ+eiZhgjALQDWUKfOj6zksIBtYWWlPWAlwQrmzok470bLgPMBw3XLymw63/H8XlDi8gX+gM4Jl0BOjYgkEL1BiAF2vDmqIhcloQSNwGkvlicoE6atF+KGRk0jOMejEuYQg0OjPMVK5061ALS9UWyDz6Vda4par0iSE4gVnrF9vqRv8BggVDVHJHbjqE3GK1+D0+jb2K9vFYmd88kItZZIJeVY1mL3Uz1tFl7n5CXTPzmvlLTTHXasyp5o6Ed7NQ8OXhJ6Wvw5dZXIlqeY0Yyx2VlyHoPQYOmUJg==\",\"auth_code\":\"ZC4834779\",\"msg\":\"已成功获得授权！\"},\"status\":200}";
        JSONObject jsonObject = JSONObject.parseObject(staticCopyright);
        if (ObjectUtil.isNull(jsonObject.getInteger("status")) || !jsonObject.getInteger("status").equals(200)) {
            throw new CrmebException("CRMEB版权接口调用失败," + jsonObject);
        }
        System.out.println("==================================== " + jsonObject.toString());
        JSONObject dataJson = jsonObject.getJSONObject(Encrypt.CRMEB_COPYRIGHT_URL_DATA);

        response.setStatus(dataJson.getInteger(Encrypt.CRMEB_COPYRIGHT_URL_STATUS));
        response.setCopyright(dataJson.getString(Encrypt.CRMEB_COPYRIGHT_URL_COPYRIGHT));
        if (!dataJson.getInteger(Encrypt.CRMEB_COPYRIGHT_URL_STATUS).equals(1)) {
            return response;
        }
        response.setAuthCode(dataJson.getString(Encrypt.CRMEB_COPYRIGHT_URL_AUTHCODE));
        response.setCompanyName(systemConfigService.getValueByKey(SysConfigConstants.CONFIG_COPYRIGHT_COMPANY_INFO));
        response.setCompanyImage(systemConfigService.getValueByKey(SysConfigConstants.CONFIG_COPYRIGHT_COMPANY_IMAGE));
        return response;
    }

    /**
     * 编辑公司版权信息
     */
    @Override
    @Transactional
    public Boolean updateCompanyInfo(CopyrightUpdateInfoRequest request) {
        Boolean update = systemConfigService.updateOrSaveValueByName(SysConfigConstants.CONFIG_COPYRIGHT_COMPANY_INFO, request.getCompanyName());
        Boolean update1 = systemConfigService.updateOrSaveValueByName(SysConfigConstants.CONFIG_COPYRIGHT_COMPANY_IMAGE, systemAttachmentService.clearPrefix(request.getCompanyImage()));
        return update && update1;
    }

    /**
     * 获取商户版权信息
     */
    @Override
    public String getCompanyInfo() {
        return systemConfigService.getValueByKey(SysConfigConstants.CONFIG_COPYRIGHT_COMPANY_INFO);
    }
}
