package com.zbkj.admin.controller.platform;

import com.zbkj.common.model.bcx.BcxChannel;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxChannelSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.BcxChannelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * description: 渠道表 控制层
 * author : linchunpeng
 * date : 2023/8/3
 */
@Slf4j
@Api(tags = "分销系统-渠道表控制层")
@RestController
@RequestMapping("/api/admin/platform/bcx/channel")
public class BcxChannelController {

    @Autowired
    private BcxChannelService bcxChannelService;

//    @PreAuthorize("hasAuthority('platform:retail:store:config:save')")
    @ApiOperation(value = "分页列表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxChannel>> getList(@Validated BcxChannelSearchRequest searchRequest, PageParamRequest pageParamRequest) {
        return CommonResult.success(CommonPage.restPage(bcxChannelService.getPage(searchRequest, pageParamRequest)));
    }

}