package com.bcxin.platform.service.meeting;


import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.meeting.ComHuaweiMeetMatch;
import com.bcxin.platform.domain.product.PoliceHuaweiMeetMatch;
import com.bcxin.platform.dto.meeting.ComHuaweiMeetMatchDto;
import com.bcxin.platform.dto.meeting.MeetingOrderRequestDTO;
import java.util.List;
import java.util.Map;

/**
 * 企业华为云会议
 * @author wangjianjun
 * @date 2020-02-03
 */
public interface HuaweiMeetMatchService {



	/**
	 * 删除企业华为云会议
	 * @param comHuaweiMeetMatch
	 * @return
	 * @throws V5BusinessException
	 */
	Result delComHuaweiMeet(ComHuaweiMeetMatch comHuaweiMeetMatch) throws Exception;

	/**
	 * <b> 删除公安华为云会议管理资源 </b>
	 * @author ZXF
	 * @create 2020/05/25 0025 10:56
	 * @version
	 * @注意事项 </b>
	 */
	Result delPoliceHuaweiMeet(PoliceHuaweiMeetMatch policeHuaweiMeetMatch) throws V5BusinessException;

	/**
	 * 获取企业华为云会议
	 * @param comHuaweiMeetMatch
	 * @auth wangjianjun
	 * @date 2020-02-03
	 * @return
	 */
	List<Map> getComHuaweiMeet(ComHuaweiMeetMatchDto comHuaweiMeetMatch) throws Exception;


	/**
	 * 新增(修改） 企业华为云会议
	 * @auth wangjianjun
	 * @date 2020-02-03
	 * @param comHuaweiMeetMatch
	 * @return
	 * @throws V5BusinessException
	 */
	Result saveComHuaweiMeet(ComHuaweiMeetMatch comHuaweiMeetMatch) throws V5BusinessException;

	/**
	 * <b> 新增(修改） 公安华为云会议 </b>
	 * @author ZXF
	 * @create 2020/05/22 0022 15:47
	 * @version
	 * @注意事项 </b>
	 */
	Result savePoliceHuaweiMeet(PoliceHuaweiMeetMatch policeHuaweiMeetMatch) throws V5BusinessException;

	/**
	 * <b> 查询华为账号的企业信息 </b>
	 * @author ZXF
	 * @create 2020/05/21 0021 10:33
	 * @version
	 * @注意事项 </b>
	 */
	List<Map> findComHuaweiMeetMatchList();

	/**
	 * 刷新登陆
	 * @author wangjianjun
	 * @date 2020/5/11
	 */
    Result refreshComHuaweiMeet(ComHuaweiMeetMatch comHuaweiMeetMatch) throws Exception;

	/**
	 * <b> 会议资源订购 </b>
	 * @author ZXF
	 * @create 2020/05/20 0020 14:57
	 * @version
	 * @注意事项 </b>
	 */
	Result purchasingResource(MeetingOrderRequestDTO dto) throws V5BusinessException;

	/**
	 * <b> 支付包周期产品订单 </b>
	 * @author ZXF
	 * @create 2020/05/29 0029 14:10
	 * @version
	 * @注意事项 </b>
	 */
	Result orderPayByOrderNo(String orderNo) throws V5BusinessException;

	/**
	 * <b> 分页查询企业资源 </b>
	 * @author ZXF
	 * @create 2020/05/21 0021 11:09
	 * @version
	 * @注意事项 </b>
	 */
	Result searchResourcesByComId(Long huaweiComId) throws V5BusinessException;

	/**
	 * <b> 管理员创建企业 </b>
	 * @author ZXF
	 * @create 2020/05/21 0021 15:21
	 * @version
	 * @注意事项 </b>
	 */
	Result buildCompanyByAdmin(String companyName, String account, String pwd) throws V5BusinessException;

	/**
	 * <b> 管理删除企业 </b>
	 * @author ZXF
	 * @create 2020/05/21 0021 15:21
	 * @version
	 * @注意事项 </b>
	 */
	Result delHuaweiManage(Long huaweiComId) throws V5BusinessException;

	/**
	 * <b> 分配企业资源 </b>
	 * @author ZXF
	 * @create 2020/05/21 0021 11:09
	 * @version
	 * @注意事项 </b>
	 */
	Result addResourcesByHuaweiComId(List<Map<String, String>> list,Long huaweiComId) throws V5BusinessException;

	/**
	 * <b> 删除企业资源 </b>
	 * @author ZXF
	 * @create 2020/05/28 0028 10:01
	 * @version
	 * @注意事项 </b>
	 */
	Result delResource(String[] ids, Long huaweiComId) throws V5BusinessException;

	/**
	 * <b> 公安所属省份下拉搜索 </b>
	 * @author ZXF
	 * @create 2020/05/22 0022 16:55
	 * @version
	 * @注意事项 </b>
	 */
	List<Map> queryPoliceRegoinCombobox();

	/**
	 * <b> 根据省编码查询下属公安机构编码列 </b>
	 * @author ZXF
	 * @create 2020/05/22 0022 17:11
	 * @version
	 * @注意事项 </b>
	 */
	List<Map> queryPoliceByProvinceIdCombobox(String provinceId);
}
