package com.bcxin.platform.service.grant;


import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.grant.ConfigBankOutletsWorkDay;
import com.bcxin.platform.domain.grant.PerBankOutletsAppointment;
import com.bcxin.platform.dto.grant.ConfigBankOutletsWorkDayTimePeriodDto;
import com.bcxin.platform.dto.grant.PerJointlyCardDTO;

import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

/**
 * 个人联名卡服务
 * @author llc
 * @date 2020-07-21
 */
public interface PerJointlyCardService {


    /**
     * 获取企业未开通联名卡人员列表
     * @param dto
     * @author llc
     * @date 2020-07-21
     */
    Result getPerOpenJointlyInfo(PerJointlyCardDTO dto) throws V5BusinessException;


    /**
     * 获取企业未开通联名卡人员列表
     * @param dto
     * @author llc
     * @date 2020-07-21
     */
    Result getNoOpenJointlyPerList(PerJointlyCardDTO dto) throws V5BusinessException;

    /**
     * 导出企业未开通联名卡人员
     * @param dto
     * @author llc
     * @date 2020-09-27
     */
    Result exportNoOpenJointlyPer(PerJointlyCardDTO dto, HttpServletResponse response);

    /**
     * 获取企业已开通联名卡人员列表
     * @param dto
     * @author llc
     * @date 2020-07-21
     */
    Result getOpenJointlyPerList(PerJointlyCardDTO dto) throws V5BusinessException;

    /**
     * 导出企业已开通联名卡人员
     * @param dto
     * @author llc
     * @date 2020-07-22
     */
    Result exportOpenJointlyPer(PerJointlyCardDTO dto, HttpServletResponse response);

    /**
     * 批量提醒开通
     * @param dto
     * @author llc
     * @date 2020-07-21
     * @return
     */
    Result batchNotice(PerJointlyCardDTO dto) throws V5BusinessException;


    /**
     * 批量提醒开通
     * @param list
     * @author llc
     * @date 2020-07-21
     * @return
     */
    Result batchSyncPerJointly(List<Map<String, String>> list) throws V5BusinessException;


    /**
     *  根据用户ID获取人员联名卡信息
     * @param perId
     * @auth llc
     * @date 2020-07-29
     * @return
     * @throws Exception
     */
    Result getPerJointlyByPerId(Long perId) throws V5BusinessException;


    /**
     * 获取保安员联名卡信息
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-07-30
     */
    Result getPerJointlyCard(PerJointlyCardDTO dto) throws V5BusinessException;


    /**
     * 获取银行网点列表
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-07-31
     */
    Result getBankOutletsList(PerJointlyCardDTO dto) throws V5BusinessException;


    /**
     * 获取银行网点工作日列表
     *
     * @param configBankOutletsWorkDay
     * @return
     * @author llc
     * @date 2020-08-21
     */
    Result getBankOutletsWorkDayList(ConfigBankOutletsWorkDay configBankOutletsWorkDay) throws V5BusinessException;


    /**
     * 获取银行网点工作日时间段列表
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-08-21
     */
    Result getBankOutletsWorkDayTimePeriodList(ConfigBankOutletsWorkDayTimePeriodDto dto) throws V5BusinessException;


    /**
     * 预约银行网点
     *
     * @param perBankOutletsAppointment
     * @return
     * @author llc
     * @date 2020-08-21
     */
    Result reserveBankOutlets(PerBankOutletsAppointment perBankOutletsAppointment) throws V5BusinessException;


    /**
     * 查询个人预约记录
     *
     * @param perBankOutletsAppointment
     * @return
     * @author llc
     * @date 2020-08-21
     */
    Result getPerBankOutletsAppointment(PerBankOutletsAppointment perBankOutletsAppointment) throws V5BusinessException;


    /**
     * 取消银行网点预约
     *
     * @param perBankOutletsAppointment
     * @return
     * @author llc
     * @date 2020-08-21
     */
    Result cancelReserveBankOutlets(PerBankOutletsAppointment perBankOutletsAppointment) throws V5BusinessException;

    /**
     * <b> 获取联名卡申请、查询地址 </b>
     * @author ZXF
     * @create 2020/09/04 0004 10:42
     * @version
     * @注意事项 </b>
     */
    Result getJointlyCardApplyUrl(Long perId) throws UnsupportedEncodingException;

    /**
     * <b> 获取联名卡申请条件 </b>
     * @author ZXF
     * @create 2020/09/09 0009 13:49
     * @version
     * @注意事项 </b>
     */
    Result getJointlyCardApplyConditions(Long perId, Long comId) throws UnsupportedEncodingException;

}