package com.bcxin.platform.service.dataSync;

import cn.hutool.core.util.StrUtil;
import com.bcxin.obpm.domain.ObpmCompany;
import com.bcxin.obpm.domain.ObpmDepartment;
import com.bcxin.obpm.domain.ObpmUser;
import com.bcxin.obpm.domain.UserDepartment;
import com.bcxin.obpm.service.ObpmCompanyService;
import com.bcxin.obpm.service.ObpmDepartmentService;
import com.bcxin.obpm.service.ObpmUserService;
import com.bcxin.obpm.service.UserDepartmentService;
import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.IdcardUtils;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.company.ComDepart;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.service.company.ComBaseInfoService;
import com.bcxin.platform.service.company.ComDepartService;
import com.bcxin.platform.service.company.PerBaseInfoService;
import com.bcxin.platform.service.company.PerOrgRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author linqinglin
 * @date 2021/11/02 0002 16:17
 */
@Service
public class ObpmDataSyncServiceImpl implements IObpmDataSyncService {

    @Resource
    private ObpmCompanyService obpmCompanyService;

    @Resource
    private ObpmUserService obpmUserService;

    @Resource
    private ObpmDepartmentService obpmDepartmentService;

    @Resource
    private UserDepartmentService userDepartmentService;

    @Resource
    private ComBaseInfoService comBaseInfoService;

    @Autowired
    private ComDepartService comDepartService;

    @Autowired
    private PerBaseInfoService perBaseInfoService;

    @Autowired
    private PerOrgRelationService perOrgRelationService;

    @Resource
    private IdWorker idWorker;

    @Override
    public void getV5InfoByTlkPerId(String tlkPerId) {
        ObpmUser obpmUser = obpmUserService.selectObpmUserById(tlkPerId);
        ObpmCompany obpmCompany = obpmCompanyService.selectObpmCompanyById(obpmUser.getDOMAINID());
        ComBaseInfo comBaseInfo = comBaseInfoService.selectComBaseInfoByTlkId(obpmCompany.getID());
        if(comBaseInfo == null) {
            comBaseInfo = new ComBaseInfo();
            comBaseInfo.setComId(idWorker.nextId());
            comBaseInfo.setIsDelete(Constants.N);
            comBaseInfo.setTlkComId(obpmCompany.getID());
            comBaseInfo.setComName(obpmCompany.getNAME());
            comBaseInfo.setRegProvince(430000);
            comBaseInfo.setRegCity(430100);
            comBaseInfo.setRegArea(430101);
            comBaseInfo.setRegAddress(obpmCompany.getREGISTERADDRESS());
            comBaseInfo.setComTreeCode(comBaseInfo.getComId().toString());
            //comBaseInfo.setTelePhone();
            comBaseInfo.setComCerNo(obpmCompany.getFIELD11());
            comBaseInfo.setComType("9");
            comBaseInfo.setComCerType("2");
            comBaseInfo.setIndustryType("0102");
            comBaseInfo.setInstitutionType("01");

            comBaseInfoService.insertComBaseInfo(comBaseInfo);
        }

        PerBaseInfo perBaseInfo = new PerBaseInfo();
        perBaseInfo.setPerId(idWorker.nextId());
        perBaseInfo.setIdCardNo(obpmUser.getFIELD12());
        perBaseInfo.setIdCardType(Constants.Y);
        perBaseInfo.setIsIncumbency(Constants.Y);
        perBaseInfo.setIsDelete(Constants.N);
        perBaseInfo.setName(obpmUser.getNAME());
        perBaseInfo.setMobilePhone(obpmUser.getLOGINNO());
        perBaseInfo.setTlkPerId(obpmUser.getID());
        perBaseInfo.setComId(comBaseInfo.getComId());
        try {
            perBaseInfo.setBirthDay(IdcardUtils.getBirthDayByIdCard(perBaseInfo.getIdCardNo()));
            perBaseInfo.setSex(IdcardUtils.getGenderByIdCard(perBaseInfo.getIdCardNo()));
        } catch (Exception e) {
            e.printStackTrace();
        }
        perBaseInfo.setPerType("010001");
        perBaseInfoService.insertPerBaseInfo(perBaseInfo);


        List<UserDepartment> dbUserDepartmentList = userDepartmentService.selectUserDepartmentByUserId(tlkPerId);

        List<PerOrgRelation> relationList = new ArrayList<>();
        if(dbUserDepartmentList.size() > 0) {
            List<ObpmDepartment> departmentList = obpmDepartmentService.selectObpmDepartmentList(obpmCompany.getID());
            List<ComDepart> dbComDepartList = comDepartService.selectListByComId(comBaseInfo.getComId());
            Map<String,ComDepart> departMap = dbComDepartList.stream().collect(Collectors.toMap(ComDepart::getTlkDepartId, Function.identity()));
            List<ComDepart> comDepartList = new ArrayList<>();
            for (ObpmDepartment obpmDepartment : departmentList) {
                ComDepart comDepart = departMap.get(obpmDepartment.getID());
                if(comDepart == null){
                    comDepart = new ComDepart();
                    comDepart.setDepartId(idWorker.nextId());
                    comDepart.setIsDelete(Constants.N);
                    comDepart.setComId(comBaseInfo.getComId());
                    comDepart.setTlkDepartId(obpmDepartment.getID());
                    comDepart.setSeq(obpmDepartment.getLEVELS().intValue());
                    comDepart.setDepartName(obpmDepartment.getNAME());

                    if(StrUtil.isNotEmpty(obpmDepartment.getSUPERIOR())) {
                        ComDepart parentDepart = departMap.get(obpmDepartment.getSUPERIOR());
                        if(parentDepart != null) {
                            comDepart.setParentDepartId(parentDepart.getDepartId());
                            comDepart.setDepartTreeCode(parentDepart.getDepartTreeCode() + comDepart.getDepartId()+"-");
                        }else{
                            System.out.println("上级部门未同步");
                        }
                    }else{
                        comDepart.setParentDepartId(-1L);
                        comDepart.setDepartTreeCode(comDepart.getDepartId()+"-");
                    }
                    comDepartList.add(comDepart);
                    departMap.put(comDepart.getTlkDepartId(),comDepart);
                }
            }
            if(comDepartList.size() > 0) {
                comDepartService.saveBatch(comDepartList);
            }

            for (UserDepartment userDepartment : dbUserDepartmentList) {
                PerOrgRelation perOrgRelation = new PerOrgRelation();
                perOrgRelation.setPerOrgRelationId(idWorker.nextId());
                perOrgRelation.setComId(comBaseInfo.getComId());
                perOrgRelation.setPerId(perBaseInfo.getPerId());
                perOrgRelation.setEntryDate(perBaseInfo.getCreateTime());
                perOrgRelation.setTlkRelationId(userDepartment.getId());
                ComDepart comDepart = departMap.get(userDepartment.getDepartmentId());
                perOrgRelation.setOrgId(comDepart.getDepartId());
                perOrgRelation.setOrgType("2");
                relationList.add(perOrgRelation);
            }
        }else{
            PerOrgRelation perOrgRelation = new PerOrgRelation();
            perOrgRelation.setPerOrgRelationId(idWorker.nextId());
            perOrgRelation.setOrgId(comBaseInfo.getComId());
            perOrgRelation.setComId(comBaseInfo.getComId());
            perOrgRelation.setPerId(perBaseInfo.getPerId());
            perOrgRelation.setOrgType("1");
            perOrgRelation.setTlkRelationId(null);
            relationList.add(perOrgRelation);
        }
        if(relationList.size() > 0) {
            perOrgRelationService.saveBatch(relationList);
        }
    }

}
