package com.bcxin.platform.service.attend;

import com.bcxin.platform.domain.attend.AttendDict;
import com.bcxin.platform.dto.attend.AttendDictDto;

import java.util.List;

/**
 * 类别Service接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendDictService{

    /**
     * 查询类别
     * 
     * @param id 类别ID
     * @return 类别
     */
    AttendDict findById(Long id);

    /**
     * 查询类别列表
     * 
     * @param attendDict 类别
     * @return 类别集合
     */
    List<AttendDictDto> selectList(AttendDictDto attendDict);


    /**
     * 编辑类别
     * 
     * @param attendDict 类别
     * @return 结果
     */
    int update(AttendDict attendDict);

    /**
     * 批量删除类别
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    /**
     * 删除类别信息
     * 
     * @param id 类别ID
     * @return 结果
     */
    int deleteById(Long id);
}
