package com.bcxin.platform.mapper.product;


import com.bcxin.platform.domain.product.ConfigProductBuyMode;
import com.bcxin.platform.dto.product.ConfigProductInfoDto;
import com.bcxin.platform.dto.product.ConfigProductTypeDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 配置产品
 *
 * @author llc
 * @date 2020-01-15
 */
@Component
public interface ConfigProductMapper{

    /**
     * 获取产品类型列表
     * @param productCategoryType
     * @param productServiceType
     * @author llc
     * @date 2020-01-15
     * @return
     */
    List<ConfigProductTypeDto> getProductTypeList(@Param("productCategoryType") String productCategoryType, @Param("productServiceType") String productServiceType);


    /**
     * 获取产品列表
     * @param productTypeList
     * @author llc
     * @date 2020-01-15
     * @return
     */
    List<ConfigProductInfoDto> getgProductInfoByTypeList(@Param("list") List<String> productTypeList);



    /**
     * 获取产品购买方式列表
     * @param productIdList
     * @author llc
     * @date 2020-01-15
     * @return
     */
    List<ConfigProductBuyMode> getProductBuyModeByIdList(@Param("list") List<String> productIdList);



}