package com.bcxin.platform.mapper.meeting;

import com.bcxin.platform.domain.meeting.ComHuaweiMeetMatch;
import com.bcxin.platform.dto.meeting.ComHuaweiMeetMatchDto;
import com.bcxin.platform.util.CrudDao;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业华为云会议映射
 *
 * @author llc
 * @date 2019-12-11
 */
@Mapper
public interface ComHuaweiMeetMatchMapper extends CrudDao<ComHuaweiMeetMatch> {

    /**
     * 获取企业华为云会议映射关系
     *
     * @param comId
     * @return
     * @auth llc
     * @date 2019-12-11
     */
    ComHuaweiMeetMatch getComHuaweiMeetMatchByComId(@Param("comId") Long comId);

    List<Map> findMapListByName(ComHuaweiMeetMatchDto dto);

    /**
     * 查询企业华为云会议映射
     *
     * @param comId 企业华为云会议映射ID
     * @return 企业华为云会议映射
     */
    ComHuaweiMeetMatch selectComHuaweiMeetMatchById(Long comId);

    /**
     * 查询企业华为云会议映射列表
     *
     * @param comHuaweiMeetMatch 企业华为云会议映射
     * @return 企业华为云会议映射集合
     */
    List<ComHuaweiMeetMatchDto> selectComHuaweiMeetMatchList(ComHuaweiMeetMatchDto comHuaweiMeetMatch);

    /**
     * 删除企业华为云会议映射
     *
     * @param comId 企业华为云会议映射ID
     * @return 结果
     */
    int deleteComHuaweiMeetMatchById(Long comId);

    int delete(Long comId);

    /**
     * 批量删除企业华为云会议映射
     *
     * @param comIds 需要删除的数据ID
     * @return 结果
     */
    int deleteComHuaweiMeetMatchByIds(String[] comIds);

    /****
     * 保存
     * @param comHuaweiMeetMatch
     * @return
     */
    int save(ComHuaweiMeetMatch comHuaweiMeetMatch);

    /****
     * 选择修改
     * @param comHuaweiMeetMatch
     * @return
     */
    int updateSelective(ComHuaweiMeetMatch comHuaweiMeetMatch);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<ComHuaweiMeetMatch> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComHuaweiMeetMatch> findByBatchId(@Param("list")List<ComHuaweiMeetMatch> list);

    int selectCount(Long comId);

    List<Map> findComHuaweiMeetMatchList();
}