package com.bcxin.platform.dto.meeting;

import com.bcxin.platform.domain.meeting.PerHuaweiMeetMatch;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 人员华为云会议映射dto
 *
 * @author llc
 * @date 2019-12-03
 */

@Data
public class PerHuaweiMeetMatchDto extends PerHuaweiMeetMatch {

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private String name;


    /**
     * 人员ID集合
     */
    @ApiModelProperty(value = "人员ID集合")
    private String perIds;


    /**
     * 手机号码集合
     */
    @ApiModelProperty(value = "手机号码集合")
    private String phones;


    /**
     * 会议主题
     */
    @ApiModelProperty(value = "会议主题")
    private String meetTheme;

    /**
     * 会议开始时间
     */
    @ApiModelProperty(value = "会议开始时间")
    private String meetStartTime;


    /**
     * 会议ID
     */
    @ApiModelProperty(value = "会议ID")
    private String meetId;

    /**
     * 主持人密码
     */
    @ApiModelProperty(value = "主持人密码")
    private String chairPwd;

    /**
     * 来宾密码
     */
    @ApiModelProperty(value = "来宾密码")
    private String guestPwd;

    /**
     * 开始时间
     */
    @ApiModelProperty(value = "开始时间")
    private String startTime;


    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间")
    private String endTime;


    /**
     * 会议UUID集合
     */
    @ApiModelProperty(value = "会议UUID集合")
    private String confUUIDs;


    /**
     * 关键字
     */
    @ApiModelProperty(value = "关键字")
    private String keyWord;

    /**
     * 云会议室状态
     */
    @ApiModelProperty(value = "云会议室状态")
    private String status;

    /**
     * 查询维度
     */
    @ApiModelProperty(value = "查询维度")
    private String queryConfMode;


    /**
     * 会议ID
     */
    @ApiModelProperty(value = "会议ID")
    private String conferenceId;
}
