package com.bcxin.platform.components;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public interface DistributedCacheProvider {
    <T> T get(String key);

    /**
     * @param key
     * @param callback
     * @param expiredInSeconds  缓存的过期时间; 秒为单位
     * @param <T>
     * @return
     */
    <T> T get(String key, Supplier<T> callback, long expiredInSeconds);

    <T> void put(String key, T data);

    /**
     * @param key
     * @param data
     * @param expires 缓存的过期时间; 秒为单位
     * @param <T>
     */
    <T> void put(String key, T data, long expires);

    <T> void putForSet(String key, Collection<T> data);

    <T> void putForSetWithExpired(String key, Collection<T> data, long expires);

    <T> void addToSet(String key, T data);

    long getSetSize(String key);

    <T> Collection<T> getRandomFromSet(String key, int count);

    <T> Collection<T> getFromSet(String key);

    <T> void removeFromSet(String key,T data);

    void clear(String prefix);

    void remove(String key);

    Collection<String> keys(String prefix);

    void remove(Collection<String> keys);


    <T> void batchPut(Map<String, T> data);

    boolean executeByLock(String key, Runnable runnable);

    boolean lock(String key, int expiredInSeconds);

    void release(String key);
}
