package com.bcxin.oaflow.mapper;

import com.bcxin.oaflow.domain.MakeUpCard;
import com.bcxin.oaflow.dto.OaBusinessDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 补卡Mapper接口
 * 
 * @author lin
 * @date 2021-09-01
 */
public interface MakeUpCardMapper {

    /**
     * 查询补卡
     * 
     * @param id 补卡ID
     * @return 补卡
     */
    MakeUpCard findById(String id);

    /**
     * 查询补卡列表 针对有排班人员
     * 
     * @param tlkPerIds
     * @param schedulDate
     * @return 补卡集合
     */
    List<MakeUpCard> selectList(@Param("list") List<String> tlkPerIds, @Param("schedulDate") String schedulDate);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<MakeUpCard> findByBatchId(@Param("list") List<MakeUpCard> list);

    /**
     * 查询出差列表
     *
     * @param tlkPerId
     * @param schedulDate
     * @return 出差集合
     */
    List<OaBusinessDto> findByUserId(@Param("tlkPerId") String tlkPerId, @Param("schedulDate") String schedulDate);

    List<MakeUpCard> selectListForPer(Map<String, Object> paramMap);

    Integer getCount(@Param("tlkPerId")String tlkPerId, @Param("schedulDate")String schedulDate);
}
