/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.company.impl;

import cn.hutool.core.text.StrSpliter;
import com.bcxin.platform.common.core.domain.entity.SysUser;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.company.ComDepart;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.dto.PerBaseInfoDto;
import com.bcxin.platform.dto.attend.AttendPerDto;
import com.bcxin.platform.dto.company.PerInfoQueryDto;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.mapper.company.ComDepartMapper;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.mapper.system.SysUserMapper;
import com.bcxin.platform.service.company.PerBaseInfoService;
import com.bcxin.platform.util.PageInfoUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class PerBaseInfoServiceImpl
implements PerBaseInfoService {
    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private PerOrgRelationMapper perOrgRelationMapper;
    @Resource
    private ComDepartMapper comDepartMapper;
    @Resource
    private SysUserMapper sysUserMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public PerBaseInfo selectPerBaseInfoById(Long perId) {
        return this.perBaseInfoMapper.selectPerBaseInfoById(perId);
    }

    @Override
    public PerBaseInfo selectPerBaseInfoByTlkId(String tlkPerId) {
        return this.perBaseInfoMapper.selectPerBaseInfoByTlkId(tlkPerId);
    }

    @Override
    public List<PerBaseInfo> selectPerBaseInfoList(PerBaseInfo perBaseInfo) {
        return this.perBaseInfoMapper.selectPerBaseInfoList(perBaseInfo);
    }

    @Override
    public int insertPerBaseInfo(PerBaseInfo perBaseInfo) {
        perBaseInfo.setPerId(this.idWorker.nextId());
        perBaseInfo.setCreateTime(DateUtils.getNowDate());
        return this.perBaseInfoMapper.insertPerBaseInfo(perBaseInfo);
    }

    @Override
    public int updatePerBaseInfo(PerBaseInfoDto perBaseInfo) {
        int result = 0;
        SysUser user = this.sysUserMapper.selectUserByPhoneNumber(perBaseInfo.getMobilePhone());
        if (user == null) {
            user = new SysUser();
            user.setUserId(Long.valueOf(this.idWorker.nextId()));
            user.setUserName(perBaseInfo.getName());
            user.setPhonenumber(perBaseInfo.getMobilePhone());
            user.setLoginName(perBaseInfo.getMobilePhone());
            user.setCreateTime(DateUtils.getNowDate());
            user.setUpdateTime(DateUtils.getNowDate());
            this.sysUserMapper.insertUser(user);
        } else if (StringUtils.isNotEmpty((String)perBaseInfo.getName()) && !perBaseInfo.getName().equals(user.getUserName())) {
            user.setUpdateTime(DateUtils.getNowDate());
            user.setUserName(perBaseInfo.getName());
            this.sysUserMapper.updateUser(user);
        }
        perBaseInfo.setUserId(user.getUserId());
        PerBaseInfo dbPerBaseInfo = this.perBaseInfoMapper.selectPerBaseInfoByTlkId(perBaseInfo.getTlkPerId());
        if (StringUtils.isNotEmpty((String)perBaseInfo.getTlkComId())) {
            ComBaseInfo comBaseInfo = this.comBaseInfoMapper.selectComBaseInfoByTlkId(perBaseInfo.getTlkComId());
            if (comBaseInfo == null) {
                throw new PlatFormBusinessException("\u516c\u53f8\u4e0d\u5b58\u5728");
            }
            perBaseInfo.setComId(comBaseInfo.getComId());
        }
        if (dbPerBaseInfo == null) {
            perBaseInfo.setPerId(this.idWorker.nextId());
            perBaseInfo.setCreateTime(DateUtils.getNowDate());
            result = this.perBaseInfoMapper.insertPerBaseInfo(perBaseInfo);
        } else {
            perBaseInfo.setIsDelete("0");
            perBaseInfo.setUpdateTime(DateUtils.getNowDate());
            result = this.perBaseInfoMapper.updatePerBaseInfo(perBaseInfo);
        }
        if (StringUtils.isNotEmpty((String)perBaseInfo.getTlkDepartIds())) {
            String[] tlkDepartIds = perBaseInfo.getTlkDepartIds().split(",");
            List<ComDepart> comDeparts = this.comDepartMapper.selectComDepartByTlkIds(tlkDepartIds);
            Map comDepartMap = comDeparts.stream().collect(Collectors.toMap(ComDepart::getTlkDepartId, Function.identity()));
            ArrayList<PerOrgRelation> relations = new ArrayList<PerOrgRelation>();
            PerOrgRelation relation = null;
            ComDepart comDepart = null;
            for (String tlkDepartId : tlkDepartIds) {
                comDepart = (ComDepart)comDepartMap.get(tlkDepartId);
                if (comDepart == null) {
                    throw new PlatFormBusinessException(tlkDepartId + "\u90e8\u95e8\u4e0d\u5b58\u5728");
                }
                relation = new PerOrgRelation();
                relation.setComId(perBaseInfo.getComId());
                relation.setOrgId(comDepart.getDepartId());
                relation.setPerId(perBaseInfo.getPerId());
                PerOrgRelation dbPerOrgRelation = this.perOrgRelationMapper.find(relation);
                if (dbPerOrgRelation == null) {
                    relation.setPerOrgRelationId(this.idWorker.nextId());
                    relation.setCreateTime(DateUtils.getNowDate());
                    relation.setUpdateTime(DateUtils.getNowDate());
                    relations.add(relation);
                    continue;
                }
                if (!"1".equals(dbPerOrgRelation.getIsDelete())) continue;
                dbPerOrgRelation.setUpdateTime(DateUtils.getNowDate());
                dbPerOrgRelation.setIsDelete("0");
                relations.add(dbPerOrgRelation);
            }
            this.perOrgRelationMapper.saveBatch(relations);
        }
        return result;
    }

    @Override
    public int editBatch(List<PerBaseInfoDto> list) {
        for (PerBaseInfoDto perBaseInfoDto : list) {
            this.updatePerBaseInfo(perBaseInfoDto);
        }
        return list.size();
    }

    @Override
    public int deletePerBaseInfoByIds(String ids) {
        return this.perBaseInfoMapper.deletePerBaseInfoByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public int deletePerBaseInfoById(Long perId) {
        return this.perBaseInfoMapper.deletePerBaseInfoById(perId);
    }

    @Override
    public Result getPerBaseInfoListByPerIds(PerBaseInfoDto dto) {
        if (StringUtil.isEmpty((String)dto.getPerIds())) {
            return Result.fail((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List perIdList = StrSpliter.split((String)dto.getPerIds(), (String)",", (boolean)true, (boolean)true);
        List<Map<String, String>> perList = this.perOrgRelationMapper.getPerBaseInfoListByPerIds(dto.getComId(), perIdList);
        return Result.success((String)"", perList);
    }

    @Override
    public Result pageForhuaweiMeetPerInfo(PerInfoQueryDto dto) {
        if (dto.getPageNumber() == null) {
            throw new V5BusinessException("-1", "\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            throw new V5BusinessException("-1", "\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<LinkedHashMap<String, Object>> list = this.perBaseInfoMapper.pageForhuaweiMeetPerInfo(dto);
        return Result.success((String)"", new PageInfoUtils<LinkedHashMap<String, Object>>(list));
    }

    @Override
    public void saveBatch(List<PerBaseInfo> perBaseInfoList) {
        this.perBaseInfoMapper.saveBatch(perBaseInfoList);
    }

    @Override
    public List<PerBaseInfo> selectPerBaseInfoByTlkIds(List<String> tlkIds) {
        return this.perBaseInfoMapper.selectPerBaseInfoByTlkIds(tlkIds);
    }

    @Override
    public List<PerBaseInfo> selectPerBaseInfoByPerIds(AttendPerDto searchDto) {
        return this.perBaseInfoMapper.selectPerBaseInfoByPerIds(searchDto);
    }
}

