
/*
Navicat MySQL Data Transfer

Source Server         : localhost_3306
Source Server Version : 50528
Source Host           : localhost:3306
Source Database       : sx_in_test

Target Server Type    : MYSQL
Target Server Version : 50528
File Encoding         : 65001

Date: 2019-07-25 17:37:54
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for company_award
-- ----------------------------
DROP TABLE IF EXISTS `company_award`;
CREATE TABLE `company_award` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `areaCode` varchar(10) DEFAULT NULL COMMENT '数据区域',
  `active` bit(1) NOT NULL COMMENT '是否有效',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `institutionType` varchar(5) DEFAULT NULL COMMENT '公司类型',
  `company_name` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `company_id` bigint(20) DEFAULT NULL COMMENT '公司id',
  `reason` longtext COMMENT '表彰奖励原因',
  `content` longtext COMMENT '表彰奖励内容',
  `award_date` varchar(20) DEFAULT NULL COMMENT '表彰奖励时间',
  `org_id` bigint(20) DEFAULT NULL COMMENT '作出表彰单位id',
  `org_name` varchar(50) DEFAULT NULL COMMENT '作出表彰单位',
  `other_org` varchar(500) DEFAULT NULL COMMENT '作出表彰奖励决定的其他单位',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='公司表彰奖励表';

-- ----------------------------
-- Table structure for company_complaint
-- ----------------------------
DROP TABLE IF EXISTS `company_complaint`;
CREATE TABLE `company_complaint` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `areaCode` varchar(10) DEFAULT NULL COMMENT '数据区域',
  `active` bit(1) NOT NULL COMMENT '是否有效',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `institutionType` varchar(5) DEFAULT NULL COMMENT '公司类型',
  `complainter` varchar(50) DEFAULT NULL COMMENT '投诉人姓名',
  `complainter_id` bigint(20) DEFAULT NULL COMMENT '投诉人id',
  `id_type` varchar(5) DEFAULT NULL COMMENT '投诉人证件类型',
  `idnum` varchar(30) DEFAULT NULL COMMENT '投诉人证件号码',
  `complainter_phone` varchar(50) DEFAULT NULL COMMENT '投诉人联系电话',
  `company_name` varchar(50) DEFAULT NULL COMMENT '投诉人公司名称',
  `company_id` bigint(20) DEFAULT NULL COMMENT '投诉人公司id',
  `complaint_company_name` varchar(50) DEFAULT NULL COMMENT '被投诉公司名称',
  `complaint_company_id` bigint(20) DEFAULT NULL COMMENT '被投诉公司id',
  `reason` longtext COMMENT '投诉原因',
  `accept_date` varchar(20) DEFAULT NULL COMMENT '受理时间',
  `accept_org_id` bigint(20) DEFAULT NULL COMMENT '受理机构id',
  `accept_org_name` varchar(50) DEFAULT NULL COMMENT '受理机构',
  `accepter_id` bigint(20) DEFAULT NULL COMMENT '受理人id',
  `accepter` varchar(50) DEFAULT NULL COMMENT '受理人',
  `disposal_date` varchar(20) DEFAULT NULL COMMENT '处理时间',
  `disposal_org_id` bigint(20) DEFAULT NULL COMMENT '处理机构id',
  `disposal_org_name` varchar(50) DEFAULT NULL COMMENT '处理机构',
  `disposaler_id` bigint(20) DEFAULT NULL COMMENT '处理决定人id',
  `disposaler` varchar(50) DEFAULT NULL COMMENT '处理决定人',
  `disposal` longtext COMMENT '处理意见',
  `rectify_require` longtext COMMENT '整改要求',
  `review` longtext COMMENT '复查情况',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='公司投诉表';

-- ----------------------------
-- Table structure for company_inspection
-- ----------------------------
DROP TABLE IF EXISTS `company_inspection`;
CREATE TABLE `company_inspection` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `areaCode` varchar(10) DEFAULT NULL COMMENT '数据区域',
  `active` bit(1) NOT NULL COMMENT '是否有效',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `institutionType` varchar(5) DEFAULT NULL COMMENT '公司类型',
  `company_name` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `company_id` bigint(20) DEFAULT NULL COMMENT '公司id',
  `task_name` varchar(50) DEFAULT NULL COMMENT '驻勤点名称',
  `task_id` bigint(20) DEFAULT NULL COMMENT '驻勤点id',
  `check_org_id` bigint(20) DEFAULT NULL COMMENT '检查公安机关id',
  `check_org` varchar(50) DEFAULT NULL COMMENT '检查公安机关',
  `checker_id` bigint(20) DEFAULT NULL COMMENT '检查人id',
  `checker` varchar(50) DEFAULT NULL COMMENT '检查人',
  `company_question` longtext COMMENT '公司检查问题',
  `task_question` longtext COMMENT '驻勤点检查问题',
  `check_date` varchar(20) DEFAULT NULL COMMENT '检查时间',
  `content` longtext COMMENT '检查内容',
  `record` longtext COMMENT '检查记录',
  `handle_org_id` bigint(20) DEFAULT NULL COMMENT '作出处理决定 公安机关id',
  `handle_org` varchar(500) DEFAULT NULL COMMENT '作出处理决定 公安机关',
  `rectify_require` longtext COMMENT '整改要求',
  `review` longtext COMMENT '复查情况',
  `org_id` bigint(20) DEFAULT NULL COMMENT '登记机构id',
  `org_name` varchar(50) DEFAULT NULL COMMENT '登记机构',
  `register_id` bigint(20) DEFAULT NULL COMMENT '登记人id',
  `register` varchar(50) DEFAULT NULL COMMENT '登记人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='公司监督检查表';

-- ----------------------------
-- Table structure for company_punish
-- ----------------------------
DROP TABLE IF EXISTS `company_punish`;
CREATE TABLE `company_punish` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `areaCode` varchar(10) DEFAULT NULL COMMENT '数据区域',
  `active` bit(1) NOT NULL COMMENT '是否有效',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `institutionType` varchar(5) DEFAULT NULL COMMENT '公司类型',
  `company_name` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `company_id` bigint(20) DEFAULT NULL COMMENT '公司id',
  `case_no` varchar(50) DEFAULT NULL COMMENT '案件编号',
  `reason` longtext COMMENT '处罚原因',
  `content` longtext COMMENT '处罚内容',
  `punish_date` varchar(20) DEFAULT NULL COMMENT '处罚时间',
  `org_id` bigint(20) DEFAULT NULL COMMENT '作出处罚单位id',
  `org_name` varchar(50) DEFAULT NULL COMMENT '作出处罚单位',
  `other_org` varchar(500) DEFAULT NULL COMMENT '作出处罚决定的其他单位',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='公司违法违规处罚表';

-- ----------------------------
-- Table structure for person_award
-- ----------------------------
DROP TABLE IF EXISTS `person_award`;
CREATE TABLE `person_award` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `areaCode` varchar(10) DEFAULT NULL COMMENT '数据区域',
  `active` bit(1) NOT NULL COMMENT '是否有效',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `institutionType` varchar(5) DEFAULT NULL COMMENT '公司类型',
  `awarder` varchar(50) DEFAULT NULL COMMENT '被表彰保安员',
  `awarder_id` bigint(20) DEFAULT NULL COMMENT '被表彰保安员id',
  `idnum` varchar(50) DEFAULT NULL COMMENT '被表彰人员身份证号',
  `company_name` varchar(50) DEFAULT NULL COMMENT '所属公司名称',
  `company_id` bigint(20) DEFAULT NULL COMMENT '所属公司id',
  `reason` longtext COMMENT '表彰奖励原因',
  `content` longtext COMMENT '表彰奖励内容',
  `award_date` varchar(20) DEFAULT NULL COMMENT '表彰奖励时间',
  `org_id` bigint(20) DEFAULT NULL COMMENT '作出表彰单位id',
  `org_name` varchar(50) DEFAULT NULL COMMENT '作出表彰单位',
  `other_org` varchar(500) DEFAULT NULL COMMENT '作出表彰奖励决定的其他单位',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='保安员表彰奖励表';

-- ----------------------------
-- Table structure for person_complaint
-- ----------------------------
DROP TABLE IF EXISTS `person_complaint`;
CREATE TABLE `person_complaint` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `areaCode` varchar(10) DEFAULT NULL COMMENT '数据区域',
  `active` bit(1) NOT NULL COMMENT '是否有效',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `institutionType` varchar(5) DEFAULT NULL COMMENT '公司类型',
  `complainter` varchar(50) DEFAULT NULL COMMENT '投诉人姓名',
  `complainter_id` bigint(20) DEFAULT NULL COMMENT '投诉人id',
  `idnum` varchar(30) DEFAULT NULL COMMENT '投诉人证件号码',
  `id_type` varchar(5) DEFAULT NULL COMMENT '投诉人证件类型',
  `complainter_phone` varchar(30) DEFAULT NULL COMMENT '投诉人联系电话',
  `company_name` varchar(50) DEFAULT NULL COMMENT '投诉人公司名称',
  `company_id` bigint(20) DEFAULT NULL COMMENT '投诉人公司id',
  `complaint_person` varchar(50) DEFAULT NULL COMMENT '被投诉保安员',
  `complaint_person_id` bigint(20) DEFAULT NULL COMMENT '被投诉保安员id',
  `reason` longtext COMMENT '投诉原因',
  `accept_date` varchar(50) DEFAULT NULL COMMENT '受理时间',
  `accept_org_id` bigint(20) DEFAULT NULL COMMENT '受理机构id',
  `accept_org_name` varchar(50) DEFAULT NULL COMMENT '受理机构',
  `accepter_id` bigint(20) DEFAULT NULL COMMENT '受理人id',
  `accepter` varchar(50) DEFAULT NULL COMMENT '受理人',
  `disposal_date` varchar(20) DEFAULT NULL COMMENT '处理时间',
  `disposal_org_id` bigint(20) DEFAULT NULL COMMENT '处理机构id',
  `disposal_org_name` varchar(50) DEFAULT NULL COMMENT '处理机构',
  `disposaler_id` bigint(20) DEFAULT NULL COMMENT '处理决定人id',
  `disposaler` varchar(50) DEFAULT NULL COMMENT '处理决定人',
  `disposal` longtext COMMENT '处理意见',
  `rectify_require` longtext COMMENT '整改要求',
  `review` longtext COMMENT '复查情况',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='保安员投诉表';

-- ----------------------------
-- Table structure for person_punish
-- ----------------------------
DROP TABLE IF EXISTS `person_punish`;
CREATE TABLE `person_punish` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `areaCode` varchar(10) DEFAULT NULL COMMENT '数据区域',
  `active` bit(1) NOT NULL COMMENT '是否有效',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `institutionType` varchar(5) DEFAULT NULL COMMENT '公司类型',
  `punisher` varchar(50) DEFAULT NULL COMMENT '被处罚保安员',
  `punisher_id` bigint(20) DEFAULT NULL COMMENT '被处罚保安员id',
  `idnum` varchar(50) DEFAULT NULL COMMENT '被处罚人员身份证号',
  `company_name` varchar(50) DEFAULT NULL COMMENT '所属公司名称',
  `company_id` bigint(20) DEFAULT NULL COMMENT '所属公司id',
  `case_no` varchar(50) DEFAULT NULL COMMENT '案件编号',
  `reason` longtext COMMENT '处罚原因',
  `content` longtext COMMENT '处罚内容',
  `punish_date` varchar(20) DEFAULT NULL COMMENT '处罚时间',
  `org_id` bigint(20) DEFAULT NULL COMMENT '作出处罚单位id',
  `org_name` varchar(50) DEFAULT NULL COMMENT '作出处罚单位',
  `other_org` varchar(500) DEFAULT NULL COMMENT '作出处罚决定的其他单位',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='保安员违法违规处罚表';






###权限
INSERT INTO `module` (`id`, `code`, `name`, `url`, `seq`, `index`, `shortcut`, `class`, `action`, `active`, `create_time`, `update_time`, `update_by`, `moduletype`, `p_id`)
VALUES ('190', 'supInsManagement', '监督检查情况管理', '', '1', '\0', '\0', '', '', '', now(), now(), 'system', '1', '122'),
('191', 'companyInspectionList', '保安服务公司监督检查', '', '1', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),
('192', 'companyAwardList', '保安服务公司表彰奖励', '', '2', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),
('193', 'companyPunishList', '保安服务公司违法违规处罚', '', '3', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),
('194', 'companyComplaintList', '保安服务公司投诉信息', '', '4', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),

('195', 'conCompanyInspectionList', '自招保安员单位监督检查', '', '5', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),
('196', 'conCompanyAwardList', '自招保安员单位表彰奖励', '', '6', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),
('197', 'conCompanyPunishList', '自招保安员单位违法违规处罚', '', '7', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),
('198', 'conCompanyComplaintList', '自招保安员单位投诉信息', '', '8', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),

('199', 'trainCompanyInspectionList', '保安培训单位监督检查', '', '9', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),
('200', 'trainCompanyAwardList', '保安培训单位表彰奖励', '', '10', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),
('201', 'trainCompanyPunishList', '保安培训单位违法违规处罚', '', '11', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),
('202', 'trainCompanyComplaintList', '保安培训单位投诉信息', '', '12', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),

('203', 'personAwardList', '保安员表彰奖励', '', '13', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),
('204', 'personPunishList', '保安员违法违规处罚', '', '14', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190'),
('205', 'personComplaintList', '保安员投诉信息', '', '15', '\0', '\0', '', '', '', now(), now(), 'system', '1', '190');


INSERT INTO `operation` (`code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`)
SELECT 'query', '查询', id, '', now(), now(), 'system'
FROM module WHERE P_ID=190;


INSERT INTO `operation` (`code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`)
SELECT 'add', '新增', id, '', now(), now(), 'system'
FROM module WHERE P_ID=190;


INSERT INTO `operation` (`code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`)
SELECT 'edit', '修改', id, '', now(), now(), 'system'
FROM module WHERE P_ID=190;

INSERT INTO`permission` (`role_id`, `module_id`, `operation_id`, `roletype`)
select pr.id,o.module_id,o.id,'2'
from police_role pr,police p,operation o,module m
where pr.active=true
and p.active=TRUE
and o.active=TRUE
and pr.orgid=p.id
and o.module_id=m.id
and m.p_id=190;

##外网权限删除
DELETE from permission where id in (
select t.id from (select p.id from module m, config c,permission p where (m.p_id = 190 or m.id=190)
AND c.active = TRUE
AND c.`key` = 'police'
AND c.`value` = '0'
and p.module_id=m.id)t
);


##外网权限删除
DELETE from operation where id in (
select t.id from (
select p.id from module m, config c,operation p where (m.p_id = 190 or m.id=190)
AND c.active = TRUE
AND c.`key` = 'police'
AND c.`value` = '0'
and p.module_id=m.id)t
);

##外网权限删除
delete FROM module where id in (
select t.id from (
select m.id from module m, config c WHERE (m.p_id = 190 or m.id=190)
AND c.active = TRUE
AND c.`key` = 'police'
AND c.`value` = '0')t
);



ALTER TABLE `problemperson`
ADD COLUMN `inform` bit(1) NULL COMMENT '是否通知企业' AFTER `active`,
ADD COLUMN `readed` bit(1) NULL COMMENT '是否已读' AFTER `inform`,
ADD COLUMN `newId` varchar(30) NULL COMMENT 'saas消息id' AFTER `readed`;

ALTER TABLE `problemperson`
ADD COLUMN `handler`  varchar(50) NULL COMMENT '处理人' AFTER `incumbencyStatus`;


ALTER TABLE `newsnotice_police`
ADD COLUMN `messageIdSaaS`  varchar(20) NULL COMMENT '公共服务安全平台消息ID' AFTER `updateflag`;


ALTER TABLE `newsnotice_police`
ADD COLUMN `sendTime`  datetime NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '发送时间' AFTER `messageIdSaaS`;



## 处理旧数据
update newsnotice_police set sendTime =  create_time where temporaryState ='1';



##公司信息
ALTER TABLE `security_company`
ADD COLUMN `comId`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公共安全服务平台企业ID' AFTER `sponsorlicenseType`,
ADD COLUMN `companyCode`  varchar(20) NULL COMMENT '公司编号' AFTER `comId`;


# 北京
INSERT INTO `sys_sequence` (`seqName`, `currentValue`, `increment`, `description`) VALUES ('seq_companycode', '100000000', '1', '公司编号');
update security_company set companyCode = CONCAT("BAG1",nextval('seq_companycode'));


DROP TABLE IF EXISTS `sys_data_change_log`;
CREATE TABLE `sys_data_change_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `method_name` varchar(500) DEFAULT NULL COMMENT '方法名',
  `old_value` longtext COMMENT '旧值',
  `new_value` longtext COMMENT '新值',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='数据变更记录表';

