package com.bcxin.ars.webservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.founderinternation.datacenter.datadownload.client.DataDownLoadFactory;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.*;

/**
 *
 * 广西南宁背景筛查
 * @author linqinglin
 * @date 2019/04/17 0017 17:48
 */
@Service("backGroupCensorService_450100")
public class NNBackGroupCensorServiceImpl extends BackGroupCensorServiceImpl implements BackGroupCensorService {

    private static Logger logger = LoggerFactory.getLogger(GXBackGroupCensorServiceImpl.class);

    @Autowired
    private BjRestLogDao bjRestLogDao;

    @Autowired
    private ConfigService configService;


    private static final String url = "http://10.151.151.83:8080/dataexchangeserver/innetApiPayload";

    /**
     * 广西人口信息管理系统-常住人口信息查询服务
     *
     */
    public static final String GX_APINAME_CZ = "gxtqdsj_R-450000230000-00002892";

    /**
     * 刑侦信息专业应用系统-全国在逃人员信息表查询服务
     */
    public static final String GX_APINAME_ZT = "gxtqdsj_R-450000230000-00001622";


    /**
     * 广西南宁警综SENDER_ID
     */
    public static final String GX_SENDER_ID = "94934D2A-9B28-4A1B-9C0A-A20E767BF3E1";

    /**
     * 广西南宁区厅AUTHCODE
     */
    public static final String GX_AUTHCODE = "YzBkNzRiOWQtMWRiOC00MjkzLTlhYjUtNzdkMDBlNDVjOTZh";

    @Override
    public String getPhoto(String idnum,String name) {
        try {
            List<String> parafs = new ArrayList<>();
            parafs.add("CERT_NO");//证号
            parafs.add("PHOTO");//照片
            //获取结果
            String resultStr = send(idnum,parafs);
            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResttype(GX_APINAME_CZ);
            log.setRequestContext(idnum);
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);
            if (StringUtil.isNotEmpty(resultStr)) {
                JSONObject result = JSON.parseObject(resultStr);
                if (Constants.NO.equals(result.get("code"))) {
                    result = JSON.parseObject(result.get("result").toString());
                    if (Constants.MINISTRY_CODE_SUCCES_SXNW.equals(result.get("status").toString())) {
                        if (result.get("data") != null) {
                            result = JSON.parseObject(result.get("data").toString());
                            String totalRows = result.get("totalRows").toString();
                            if (Long.parseLong(totalRows) > 0) {
                                JSONArray results = JSONArray.parseArray(result.get("results").toString());
                                result = (JSONObject)results.get(0);
                                return result.get("PHOTO").toString();
                            }
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new ArsException("获取人口库照片信息失败！");
        }

        return StringUtil.EMPTY;
    }

    /**
     *
     * 广西人口信息管理系统-常住人口信息查询服务	gxtqdsj_R-450000230000-00002892
     * 获取人口库信息
     * @param idnum
     * @return
     */
    @Override
    public PersonBaseInfo getPopulationInfo(String idnum,boolean needPhoto) {
        PersonBaseInfo personBaseInfo = null;
        try {
            List<String> parafs = new ArrayList<>();
            parafs.add("NAME");//姓名
            parafs.add("CERT_NO");//证号
            parafs.add("DOMIC_ADDR_NAME");//户籍地址
            //获取结果
            String resultStr = send(idnum,parafs);
            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResttype(GX_APINAME_CZ);
            log.setResponseContext(resultStr);
            log.setRequestContext(idnum);
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);
            if (StringUtil.isNotEmpty(resultStr)) {
                JSONObject result = JSON.parseObject(resultStr);
                if (Constants.NO.equals(result.get("code"))) {
                    result = JSON.parseObject(result.get("result").toString());
                    if (Constants.MINISTRY_CODE_SUCCES_SXNW.equals(result.get("status").toString())) {
                        if (result.get("data") != null) {
                            result = JSON.parseObject(result.get("data").toString());
                            String totalRows = result.get("totalRows").toString();
                            if (Long.parseLong(totalRows) > 0) {
                                JSONArray results = JSONArray.parseArray(result.get("results").toString());
                                result = (JSONObject)results.get(0);
                                personBaseInfo = new PersonBaseInfo();
                                personBaseInfo.setName(result.get("NAME").toString());
//                                personBaseInfo.setPhoto(result.get("PHOTO").toString());
                                personBaseInfo.setAddress(result.get("DOMIC_ADDR_NAME").toString());
                                if(needPhoto){
                                    personBaseInfo.setPhoto(getPhoto(idnum,personBaseInfo.getName()));
                                }
                            }
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new ArsException("获取人口库信息失败！");
        }

        return personBaseInfo;
    }

    private String send(String idnum,List<String> parafs){
        try {
            Map<String, Object> paramMap = new HashMap<>();
            Map<String, Object> params = new HashMap<>();

            params.put("areaCode", "450100000000");
            params.put("qqdwdm", "南宁市公安局");
            params.put("qqdwmc", "450100000000");
            params.put("qqr", "450100210000");
            params.put("qqrsfzh", "450100210000");
            params.put("messageSequence", UUID.randomUUID());
            params.put("condition", " CERT_NO ='" + idnum + "' and PERSON_STAT_NAME='有效'");
            params.put("parafs", parafs);
            params.put("maxReturnNum", "1");

            paramMap.put("authCode", GX_AUTHCODE);
            paramMap.put("apiName", GX_APINAME_CZ);
            paramMap.put("params", JSON.toJSONString(params));

            logger.error("广西人口信息管理系统-常住人口信息请求参数：{}",JSON.toJSONString(paramMap));
            logger.error("广西人口信息管理系统-常住人口信息请求地址：{}",url);
            //获取结果
            String result = postWithJson(url, paramMap);
            logger.error("广西人口信息管理系统-常住人口信息返回结果：{}",result);
            return result;
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage(),e);
            throw new ArsException("广西人口信息管理系统-常住人口信息查询服务异常！");
        }
    }

    private String postWithJson(String requestUrl, Map<String, Object> paramMap){
        String returnValue = StringUtil.EMPTY;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        ResponseHandler<String> responseHandler = new BasicResponseHandler();
        try{
            //第一步：创建HttpClient对象
            httpClient = HttpClients.createDefault();
            //第二步：创建httpPost对象
            HttpPost httpPost = new HttpPost(requestUrl);
            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(30000);
            requestConfig.setConnectionRequestTimeout(30000);
            requestConfig.setSocketTimeout(30000);
            //第三步：给httpPost设置JSON格式的参数
            StringEntity requestEntity = new StringEntity(JSON.toJSONString(paramMap),"utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity(requestEntity);
            httpPost.setConfig(requestConfig.build());

            //第四步：发送HttpPost请求，获取返回值
            returnValue = httpClient.execute(httpPost,responseHandler); //调接口获取返回值时，必须用此方法
        }catch(Exception e){
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new ArsException(requestUrl+"：接口调用异常！");
        }finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        //第五步：处理返回值
        return returnValue;
    }

    @Override
    public List<BackgroundApproval> censorFromBase(BackgroundApprovalDto dto,boolean needCZ) {
        Long businessid = dto.getBusinessid();
        String businesstype = dto.getBusinesstype();
        String idNumber = dto.getIdNumber();
        String name = dto.getRealName();
        List<BackgroundApproval> list = new ArrayList<>();
        try {
            BackgroundApproval cz_BackgroundApproval = new BackgroundApproval();
            cz_BackgroundApproval.setActive(true);
            cz_BackgroundApproval.setCreateTime(new Date());
            cz_BackgroundApproval.setUpdateTime(new Date());
            cz_BackgroundApproval.setBusinessid(businessid);
            cz_BackgroundApproval.setApprovaldate(new Date());
            cz_BackgroundApproval.setBusinesstype(businesstype);
            BackgroundApproval dt_BackgroundApproval = cz_BackgroundApproval.clone();
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();
            if(needCZ) {
                if (!Constants.AUTH_STATE_PASS.equals(dto.getAuthState())) {
                    censorCZ(idNumber, name, cz_BackgroundApproval);
                    list.add(cz_BackgroundApproval);
                }
            }

            // 在逃
            dt_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_DT);
            boolean dt = isEscapedPerson(idNumber);
            if(dt){
                dt_BackgroundApproval.setApprovalreason("在逃人员");
                dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
            }else{
                dt_BackgroundApproval.setApprovalreason("无在逃记录");
                dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
            }
            list.add(dt_BackgroundApproval);

            // 犯罪
            wf_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_WF);
            boolean wf = isKeyPerson(idNumber);
            if(wf){
                wf_BackgroundApproval.setApprovalreason("有违法犯罪记录");
                wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
            }else{
                wf_BackgroundApproval.setApprovalreason("无违法犯罪记录");
                wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
            }
            list.add(wf_BackgroundApproval);

        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage(),e);
            throw new ArsException("查询人口库异常！");
        }
        return list;
    }

    /**
     * 广西【警综-重点人员】
     * 是否重点人员
     * @param idnum
     */
    private boolean isKeyPerson(String idnum){
        try {
            DataDownLoadFactory dataDownLoadFactory = DataDownLoadFactory.getInstance();
            if(dataDownLoadFactory == null){
                logger.error("DataDownLoadFactory异常");
            }
            //此方法新建一个实例 相当于new
            String ip = "10.236.17.18";
            String port = "8212";
            String methodName = "QueryJzZdry";
            String tableCode = "010112";
            String senderId = GX_SENDER_ID;
            String condition = " SFZH ='"+idnum+"' and YXX = '1' ";
            String[] fileds = {"XM","ZDRYLBBJ"};
            //String[] fileds = {"*"};
            int totalCount = 1;// 0=< 默认返回所有符合条件的数据，>0 符合条件的totalCount条
            int waittime = 0;//大于等于0为等待wait ms ，等于 0 为不等待
            String result = dataDownLoadFactory.getFromRemote(ip, port, methodName, tableCode, senderId, condition, fileds, totalCount, waittime);
            logger.error("广西【警综-重点人员】返回结果：{}",result);
            long start = System.currentTimeMillis();
            int sum = 0;
            boolean isHadData = false;
            if ("success".equals(result)) {
                if (dataDownLoadFactory.getResultQueue() != null || !dataDownLoadFactory.isClose()) {
                    //当返回队列不为空或者链接未关闭继续等待接收数据
                    while (!dataDownLoadFactory.getResultQueue().isEmpty() || !dataDownLoadFactory.isClose()) {
                        Object[] resultstr = dataDownLoadFactory.getResultQueue().poll();
                        //获取返回数据为 Object[2]  rsultstr[0] 为一个map key:value  分别是字段名和字段类型编码（对应类型下面会有介绍）；
                        //map为linkedHashMap 获取keyset为字段set；
                        //resultstr[1] 为List<Object[]> 返回数据包，
                        //object[]对应一个row每个object对应一列，和上面keyset 字段对应
                        if (resultstr == null) {
                            //休息1秒
                            Thread.sleep(1);
                        } else {//获取到数据 TO DO数据处理
                            isHadData = true;
                            sum++;
                            logger.error("广西【警综-重点人员】返回结果：{}",JSON.toJSONString(resultstr));
                            if (resultstr.length == 2 && resultstr[0] != null && resultstr[1] != null) {
                                List<Object[]> resultList = (List<Object[]>) resultstr[1];
                            }
                        }
                    }
                    logger.error("数据结果队列：" + isHadData);
                    long end = System.currentTimeMillis();
                    logger.error("耗时：" + (double) (end - start) / 1000 + " 秒");
                    dataDownLoadFactory.closeSession();
                    logger.error("耗时：" + (double) (System.currentTimeMillis() - start) / 1000 + " 秒");
                }
            }
            return isHadData;
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            throw new ArsException("广西【警综-重点人员】调用异常！！");
        }
    }

    /**
     * 刑侦信息专业应用系统-全国在逃人员信息表查询服务	gxtqdsj_R-450000230000-00001622
     * 是否在逃人员
     * @param idnum
     */
    private boolean isEscapedPerson(String idnum){
        try {
            Map<String, Object> paramMap = new HashMap<>();
            Map<String, Object> params = new HashMap<>();


            List<String> parafs = new ArrayList<>();
            parafs.add("NAME");//姓名
            parafs.add("UNDO_ORGA_PSAG_CODE");//撤销单位代码
            parafs.add("UNDO_JUDGE_FLAG");//撤销判断标识

            params.put("areaCode", "450100000000");
            params.put("qqdwdm", "南宁市公安局");
            params.put("qqdwmc", "450100000000");
            params.put("qqr", "450100210000");
            params.put("qqrsfzh", "450100210000");
            params.put("messageSequence", UUID.randomUUID());
//            params.put("condition", " CERT_NO ='" + idnum + "' and UNDO_ORGA_PSAG_CODE =''");
            params.put("condition", " CERT_NO ='" + idnum + "'");
            params.put("parafs", parafs);
            params.put("maxReturnNum", "20");

            //NAME,PHOTO,DOMIC_ADDR_NAME,CERT_NO

            paramMap.put("authCode", GX_AUTHCODE);
            paramMap.put("apiName", GX_APINAME_ZT);
            paramMap.put("params", JSON.toJSONString(params));

            logger.error("刑侦信息专业应用系统-全国在逃人员信息表请求参数：{}",JSON.toJSONString(paramMap));
            logger.error("刑侦信息专业应用系统-全国在逃人员信息表请求地址：{}",url);
            //获取结果
            String resultStr = postWithJson(url, paramMap);
            logger.error("刑侦信息专业应用系统-全国在逃人员信息表返回结果：{}",resultStr);

            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResttype(GX_APINAME_ZT);
            log.setResponseContext(resultStr);
            log.setRequestContext(idnum);
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);
            if (StringUtil.isNotEmpty(resultStr)) {
                JSONObject result = JSON.parseObject(resultStr);
                if (Constants.NO.equals(result.get("code"))) {
                    result = JSON.parseObject(result.get("result").toString());
                    if (Constants.MINISTRY_CODE_SUCCES_SXNW.equals(result.get("status").toString())) {
                        if (result.get("data") != null) {
                            result = JSON.parseObject(result.get("data").toString());
                            String totalRows = result.get("totalRows").toString();
                            if (Long.parseLong(totalRows) > 0) {
                                return true;
                            }
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            throw new ArsException("刑侦信息专业应用系统-全国在逃人员信息调用异常！！");
        }

        return false;
    }


    public static void main(String[] args) {

        DataDownLoadFactory dataDownLoadFactory = DataDownLoadFactory.getInstance();
        if(dataDownLoadFactory == null){
            logger.error("DataDownLoadFactory异常");
        }
///10.236.17.18/EZSPservice
        //此方法新建一个实例 相当于new
        //String ip = "10.236.17.18";
        //String port = "80";
        //String methodName = "QueryJzZdry";
        //String tableCode = "010112";
        //String senderId = GX_SENDER_ID;
        //String condition = " SFZH ='"+"111111"+"' and YXX = '1' ";
        //String[] fileds = {"XM","ZDRYLBBJ"};
        ////String[] fileds = {"*"};
        //int totalCount = 1;// 0=< 默认返回所有符合条件的数据，>0 符合条件的totalCount条
        //int waittime = 30000;//大于等于0为等待wait ms ，等于 0 为不等待
        //String result111 = dataDownLoadFactory.getFromRemote(ip, port, methodName, tableCode, senderId, condition, fileds, totalCount, waittime);
        //logger.error("广西【警综-重点人员】返回结果：{}",result111);
        test();
        String resultStr = "{\"code\":\"0\",\"message\":\"查询成功\",\"result\":{\"status\":200,\"msg\":\"正常\",\"messageSequence\":\"7412dcfa-a72e-4e17-b551-ecc991391193\",\"data\":{\"totalRows\":\"3\",\"results\":[{\"DOMIC_ADDR_NAME\":\"广西靖西市新甲乡万吉村安吉屯14号\",\"NAME\":\"赵素英\"}]},\"qtime\":244}}";


        if (StringUtil.isNotEmpty(resultStr)) {
            JSONObject result = JSON.parseObject(resultStr);
            if (Constants.NO.equals(result.get("code"))) {
                result = JSON.parseObject(result.get("result").toString());
                if (Constants.MINISTRY_CODE_SUCCES_SXNW.equals(result.get("status").toString())) {
                    if (result.get("data") != null) {
                        result = JSON.parseObject(result.get("data").toString());
                        String totalRows = result.get("totalRows").toString();
                        if (Long.parseLong(totalRows) > 0) {
                            JSONArray results = JSONArray.parseArray(result.get("results").toString());
                            result = (JSONObject)results.get(0);
                            System.out.println(result.get("NAME").toString());
                            System.out.println(result.get("DOMIC_ADDR_NAME").toString());
                            System.out.println(result.get("VEHTIC_NO"));
                        }
                    }
                }
            }
        }
    }

    private static PersonBaseInfo test(){
        PersonBaseInfo personBaseInfo = null;
        try {

            List<String> parafs = new ArrayList<>();
            parafs.add("NAME");//姓名
            parafs.add("DOMIC_ADDR_NAME");//户籍地址

            //获取结果
            String resultStr = "{\"code\":\"0\",\"message\":\"查询成功\",\"result\":{\"status\":200,\"msg\":\"正常\",\"messageSequence\":\"7412dcfa-a72e-4e17-b551-ecc991391193\",\"data\":{\"totalRows\":\"3\",\"results\":[{\"DOMIC_ADDR_NAME\":\"广西靖西市新甲乡万吉村安吉屯14号\",\"NAME\":\"赵素英\"}]},\"qtime\":244}}";

            if (StringUtil.isNotEmpty(resultStr)) {
                JSONObject result = JSON.parseObject(resultStr);
                if (Constants.NO.equals(result.get("code"))) {
                    result = JSON.parseObject(result.get("result").toString());
                    if (Constants.MINISTRY_CODE_SUCCES_SXNW.equals(result.get("status").toString())) {
                        if (result.get("data") != null) {
                            result = JSON.parseObject(result.get("data").toString());
                            String totalRows = result.get("totalRows").toString();
                            if (Long.parseLong(totalRows) > 0) {
                                JSONArray results = JSONArray.parseArray(result.get("results").toString());
                                result = (JSONObject)results.get(0);
                                personBaseInfo = new PersonBaseInfo();
                                personBaseInfo.setName(result.get("NAME").toString());
//                                personBaseInfo.setPhoto(result.get("PHOTO").toString());
                                personBaseInfo.setAddress(result.get("DOMIC_ADDR_NAME").toString());
                            }
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage());
        }

        return personBaseInfo;
    }
}
