package com.bcxin.ars.webservice.impl;

import com.bcxin.ars.dao.ProblemPersonDao;
import com.bcxin.ars.dao.ProblemPersonDaoAop;
import com.bcxin.ars.dao.SecurityCompanyPersonDao;
import com.bcxin.ars.dao.SecurityPersonDaoAop;
import com.bcxin.ars.dao.sb.BackgroundApprovalDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.webservice.ClientUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 背景筛查 + 人口库 默认 陕西库
 * 不同省如果不使用默认的陕西库 则各自去重写对应的方法
 * @author linqinglin
 * @date 2019/04/17 0017 17:48
 */
@Service
public class BackGroupCensorServiceImpl {

    /***
     * 日志
     */
    private static Logger logger = LoggerFactory.getLogger(BackGroupCensorServiceImpl.class);

    @Autowired
    private PoliceService policeService;

    @Autowired
    private ProblemPersonDao problemPersonDao;

    @Autowired
    private ProblemPersonDaoAop problemPersonDaoAop;

    @Autowired
    private SecurityCompanyPersonDao securityCompanyPersonDao;

    @Autowired
    private SecurityPersonDaoAop personDaoAop;

    @Autowired
    private BackgroundApprovalDao backgroundApprovalDao;

    @Autowired
    private ClientUtil clientUtil;

    @Value("${ZAFLAG}")
    private String ZAFLAG;


    public final void censorCZ(String idnum,String name,BackgroundApproval cz_BackgroundApproval){
        // 人口库
        try {
            cz_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_CZ);
            PersonBaseInfo personBaseInfo = getPopulationInfo(idnum,false);

            if(personBaseInfo != null){
                if(StringUtil.isNotEmpty(personBaseInfo.getName()) && name.equals(personBaseInfo.getName())){
                    cz_BackgroundApproval.setApprovalreason("主项信息符合");
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }else{
                    //姓名信息不匹配
                    cz_BackgroundApproval.setApprovalreason(Constants.LIBRARYTYPE_CZ_FAIL_MESSAGE);
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                }
            }else{
                cz_BackgroundApproval.setApprovalreason(Constants.LIBRARYTYPE_CZ_FAIL);
                cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
            }


        }catch(Exception e){
            logger.error(e.getMessage(),e);
            throw new ArsException("查询人口库异常！");
        }

    }

    public PersonBaseInfo getPopulationInfo(String idnum, boolean needPhoto) {
        return null;
    }

    /**
     * 非生产内网 背景审查全部审查通过
     * @param dto
     * @return
     */
    public final List<BackgroundApproval> censorNoInrawPro(BackgroundApprovalDto dto) {
        List<BackgroundApproval> list = new ArrayList<>();
        try {
            Long businessid = dto.getBusinessid();
            String businesstype = dto.getBusinesstype();
            BackgroundApproval cz_BackgroundApproval = new BackgroundApproval();
            cz_BackgroundApproval.setActive(true);
            cz_BackgroundApproval.setCreateTime(new Date());
            cz_BackgroundApproval.setUpdateTime(new Date());
            cz_BackgroundApproval.setApprovaldate(new Date());
            cz_BackgroundApproval.setBusinessid(businessid);
            cz_BackgroundApproval.setBusinesstype(businesstype);
            cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
            cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);

            /**
             * 克隆对象，减少重复创建对象赋值代码
             * 自定义类需要实现Cloneable的clone()方法
             */
            BackgroundApproval xd_BackgroundApproval = cz_BackgroundApproval.clone();
            BackgroundApproval dt_BackgroundApproval = cz_BackgroundApproval.clone();
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();


            cz_BackgroundApproval.setApprovalreason("主项信息符合");
            xd_BackgroundApproval.setApprovalreason("无吸毒记录");
            dt_BackgroundApproval.setApprovalreason("无在逃记录");
            wf_BackgroundApproval.setApprovalreason("无违法犯罪记录");

            cz_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_CZ);
            xd_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_XD);
            dt_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_DT);
            wf_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_WF);

            list.add(cz_BackgroundApproval);
            list.add(xd_BackgroundApproval);
            list.add(dt_BackgroundApproval);
            list.add(wf_BackgroundApproval);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }


    /****
     * 背景筛查
     * @param dto 业务信息
     */
    public final List<BackgroundApproval> getCensorResult(BackgroundApprovalDto dto) {
        if (!ObjectUtils.equals(Constants.INRAW_PRO_YES, ZAFLAG)){
            //非生产内网
            return censorNoInrawPro(dto);
        }else{
            /**
             * 不同省份 实现各自的censorFromBase(dto)方法
             */
            return censorFromBase(dto,true);
        }
    }

    /**
     * 根据背景筛查结果列表返回字符串类型的结果
     * @param backgroundApprovals
     * @return 字符串类型的结果
     */
    public final String getCensorResult(List<BackgroundApproval> backgroundApprovals) {
        StringBuffer problemtype = new StringBuffer(StringUtil.EMPTY);
        for (BackgroundApproval backgroundApproval : backgroundApprovals){
            String strResult = StringUtil.EMPTY;
            if(ApprovalState.SHBTG.equals(backgroundApproval.getApprovalstate())){
                switch (backgroundApproval.getLibraryType()){
                    case Constants.LIBRARYTYPE_CZ:
                        strResult = Constants.LIBRARYTYPE_CZ_FAIL;
                        break;
                    case Constants.LIBRARYTYPE_XD:
                        strResult = Constants.LIBRARYTYPE_XD_FAIL;
                        break;
                    case Constants.LIBRARYTYPE_DT:
                        strResult = Constants.LIBRARYTYPE_DT_FAIL;
                        break;
                    case Constants.LIBRARYTYPE_WF:
                        strResult = Constants.LIBRARYTYPE_WF_FAIL;
                        break;
                    case Constants.LIBRARYTYPE_BJ_HC:
                        strResult = backgroundApproval.getApprovalreason();
                        break;
                    default:
                        break;
                }
                if (StringUtil.isEmpty(problemtype.toString())) {
                    problemtype.append(strResult);
                } else {
                    problemtype.append(Constants.COMMA + strResult);
                }
            }
        }

        return problemtype.toString();
    }

    /***
     * 保安员背景筛查保存到问题人员表
     * 所有子类共用此方法 不可@Override重写
     * @param person 问题人员
     * @return 背景筛查结果
     */
    public final void censorSaveProblemPerson(SecurityPerson person, List<BackgroundApproval> backgroundApprovals) {
        //身份证号码
        String idNumber = person.getIdNumber();
        //姓名
        String name = person.getRealName();
        //问题人员
        ProblemPerson problemPerson  = new ProblemPerson();
        //查询对象
        ProblemPerson query =  new ProblemPerson();
        query.setPersonid(person.getId());
        query.setDispose(Constants.DISPOSE_NO);
        List<ProblemPerson> list = problemPersonDao.findByPersonIdForUnDispose(query);
        if(list!=null && list.size()>0){
            problemPerson =  list.get(0);
        }else {
            problemPerson.setCreateTime(new Date());
            //处理状态
            problemPerson.setDispose(Constants.DISPOSE_NO);
        }
        problemPerson.setComparisonDate(new Date());
        //如果身份证号为空，显示返回
        if (person == null) {
            logger.error("异常身份证号：" + idNumber);
            return ;
        }
        SecurityCompanyPerson securityCompanyPerson = securityCompanyPersonDao.findByPersonId(person.getId());
        problemPerson.setUpdateTime(new Date());
        problemPerson.setActive(true);
        problemPerson.setUpdateBy("systemAuto");
        problemPerson.setIdnumber(idNumber);
        //就职状态
        problemPerson.setIncumbencyStatus(person.getIncumbencyStatus());
        //获取公司信息
        if (securityCompanyPerson != null) {
            if (securityCompanyPerson.getCompany() != null) {

                //公司名称
                problemPerson.setCompanyid(securityCompanyPerson.getCompany().getId());
                //公司主键
                problemPerson.setCompanyname(securityCompanyPerson.getCompany().getName());
                //公司信息
                SecurityCompany company = securityCompanyPerson.getCompany();
                if(company.getComId().equals("591221865301671937") || (StringUtil.isNotEmpty(company.getParentId()) && company.getParentId().equals("591221865301671937"))){
                    /***
                     * 保总特殊处理
                     */
                    Police police = policeService.findById(1000L);
                    if(police!=null) {
                        problemPerson.setOrgId(Long.valueOf(police.getId()));
                        //监控机构名称
                        problemPerson.setOrgName(police.getOrgname());
                        //所属区域
                        problemPerson.setAreaCode(police.getAreacode());
                    }
                }else if(company.getId() == 610907743891451L || company.getId()== 610238522001631L){
                    /**
                     * 振远特殊处理
                     */
                    Police police = policeService.findById(2000L);
                    if(police!=null) {
                        problemPerson.setOrgId(Long.valueOf(police.getId()));
                        //监控机构名称
                        problemPerson.setOrgName(police.getOrgname());
                        //所属区域
                        problemPerson.setAreaCode(police.getAreacode());
                    }
                }else {
                    //监控机构ID
                    if (StringUtil.isNotEmpty(securityCompanyPerson.getCompany().getOrgId())) {
                        problemPerson.setOrgId(Long.valueOf(securityCompanyPerson.getCompany().getOrgId()));
                        //监控机构名称
                        problemPerson.setOrgName(securityCompanyPerson.getCompany().getOrgName());
                        //所属区域
                        problemPerson.setAreaCode(securityCompanyPerson.getCompany().getAreaCode());
                    }
                }
            }
        }
        //用户信息
        //手机
        problemPerson.setPhone(person.getPhone());
        //姓名
        problemPerson.setName(person.getRealName());
        //性别
        problemPerson.setSex(person.getGender());
        //人员
        problemPerson.setPersonid(person.getId());
        //背景筛查标记
        boolean result = true;
        //判断类型是否存在数据库
        boolean existsFlag = false;
        StringBuffer problemtype =  new StringBuffer();
        //循环背景筛查记录，检查是否有不通过
        if(backgroundApprovals!=null && backgroundApprovals.size()>0) {
            for (BackgroundApproval backgroundApproval : backgroundApprovals) {
                if (ApprovalState.SHBTG.equals(backgroundApproval.getApprovalstate())) {
                    problemtype.append(backgroundApproval.getApprovalreason()).append(Constants.COMMA);
                    result = false;
                }
            }
        }
        problemPerson.setUpdateflag(true);
        query.setCompanyid(problemPerson.getCompanyid());
        List<ProblemPerson> dbList = problemPersonDao.findByPersonIdForMax(query);
        if (!result) {
            //新比对类型
            String[] problemtypes =  problemtype.toString().split(Constants.COMMA);
            for (String type:problemtypes) {
                //有违法犯罪记录和违法犯罪转换成同一个类型
                type = type.replaceAll("有违法犯罪记录","违法犯罪");
                //姓名信息有误和身份证号不存在不对比
                if("姓名信息有误".equals(type) || "身份证号不存在".equals(type)){
                    continue;
                }
                for(ProblemPerson p:dbList){
                    //已存在的问题类型
                    String[] dbProblemtypes = p.getProblemtype().split(Constants.COMMA);
                    for(String dbType:dbProblemtypes){
                        //姓名信息有误和身份证号不存在不对比
                        if("姓名信息有误".equals(dbType) || "身份证号不存在".equals(dbType)){
                            continue;
                        }
                        //有违法犯罪记录和违法犯罪转换成同一个类型
                        dbType = dbType.replaceAll("有违法犯罪记录","违法犯罪");
                        if(StringUtil.trim(dbType).equals(StringUtil.trim(type))){
                            existsFlag = true;
                            break;
                        }
                    }
                    if(existsFlag){
                        break;
                    }
                }
            }
            //如果类型在之前的列表中不存在，生成新的数据
            if(!existsFlag) {
                //去悼最后一位
                problemtype.deleteCharAt(problemtype.length() - 1);
                //信息有误
                if (Constants.LIBRARYTYPE_CZ_FAIL_MESSAGE.equals(problemtype.toString()) || Constants.LIBRARYTYPE_CZ_FAIL.equals(problemtype.toString())) {
                    problemPerson.setPersonType(Constants.PERSONTYPE_INFO);
                    //在逃
                } else if (problemtype.toString().indexOf(Constants.LIBRARYTYPE_DT_QUERY) >= 0) {
                    problemPerson.setPersonType(Constants.PERSONTYPE_LARGE);
                    //前科
                } else {
                    problemPerson.setPersonType(Constants.PERSONTYPE_CRIMINAL);
                }
                //问题类型
                problemPerson.setProblemtype(problemtype.toString());
                if (problemPerson.getId() != null) {
                    problemPersonDaoAop.update(problemPerson);
                } else {
                    //只有背景筛查不通过再生成记录
                    problemPersonDao.save(problemPerson);
                }
            }
        }else{
            if(problemPerson.getId()!=null){
                problemPerson.setActive(false);
                //只有背景筛查不通过再生成记录
                problemPersonDaoAop.update(problemPerson);
            }
        }
        //更新人员信息的背景筛查状态
        if (result) {
            person.setCensorStatus(Constants.CENSORSTATUS_PASS);
            //背景筛查通过后，人员关联旧数据证书，判断证书是否存在，存在则关联
            //this.updateCerForOldData(problemPerson);
        } else {
            person.setCensorStatus(Constants.CENSORSTATUS_UNPASS);
        }
        person.setCensorTime(new Date());
        personDaoAop.updateSelective(person);
    }

    /***
     * 背景筛查不通过人员重新比对
     * @param person 问题人员
     * @return 背景筛查结果
     */
    public final void censorSaveProblemPersonNoPassCensorStatus(SecurityPerson person, List<BackgroundApproval> backgroundApprovals) {
        //身份证号码
        String idNumber = person.getIdNumber();
        //姓名
        String name = person.getRealName();
        //问题人员
        ProblemPerson problemPerson  = new ProblemPerson();

        //查询对象
        ProblemPerson query =  new ProblemPerson();
        query.setPersonid(person.getId());
        query.setDispose(Constants.DISPOSE_NO);
        List<ProblemPerson> list = problemPersonDao.findByPersonIdForMax(query);

        problemPerson.setCreateTime(new Date());
        problemPerson.setComparisonDate(new Date());
        //处理状态
        problemPerson.setDispose(Constants.DISPOSE_NO);
        //背景筛查标记
        boolean result = true;
        boolean problemChange = false;
        StringBuffer problemtype =  new StringBuffer();
        //循环背景筛查记录，检查是否有不通过
        for (BackgroundApproval backgroundApproval : backgroundApprovals) {
            if(ApprovalState.SHBTG.equals(backgroundApproval.getApprovalstate())){
                problemtype.append(backgroundApproval.getApprovalreason()).append(Constants.COMMA);
                result = false;
            }
        }
        if(!result){
            //新比对类型
            String[] problemtypes =  problemtype.toString().split(Constants.COMMA);
            for (String type:problemtypes
            ) {
                //有违法犯罪记录和违法犯罪转换成同一个类型
                type = type.replaceAll("有违法犯罪记录","违法犯罪");
                //姓名信息有误和身份证号不存在不对比
                if("姓名信息有误".equals(type) || "身份证号不存在".equals(type)){
                    continue;
                }
                //判断类型是否存在数据库
                boolean existsFlag = false;
                for(ProblemPerson p:list){
                    //已存在的问题类型
                    String[] dbProblemtypes = p.getProblemtype().split(Constants.COMMA);
                    for(String dbType:dbProblemtypes){
                        //姓名信息有误和身份证号不存在不对比
                        if("姓名信息有误".equals(dbType) || "身份证号不存在".equals(dbType)){
                            continue;
                        }
                        //有违法犯罪记录和违法犯罪转换成同一个类型
                        dbType = dbType.replaceAll("有违法犯罪记录","违法犯罪");
                        if(StringUtil.trim(dbType).equals(StringUtil.trim(type))){
                            existsFlag = true;
                            break;
                        }
                    }
                    if(existsFlag){
                        break;
                    }
                }
                //如果类型在之前的列表中没有，则类型没有增加
                if(!existsFlag){
                    problemChange =true;
                }
            }

        }
        //背景筛查状态，第一次
        person.setCensorStatus(Constants.CENSORSTATUS_UNPASS);
        person.setCensorCriminalStatus(Constants.CENSORSTATUS_UNPASS);
        person.setCensorTime(new Date());
        //更新前科背景筛查记录
        personDaoAop.updateSelective(person);
        //如果背景筛查结果和之前一致则不生成新的数据
        if(result || !problemChange) {
            return;
        }
        if(!result){
            //去悼最后一位
            problemtype.deleteCharAt(problemtype.length() - 1);
        }
        //如果身份证号为空，显示返回
        if (person == null) {
            logger.error("异常身份证号：" + idNumber);
            return ;
        }
        SecurityCompanyPerson securityCompanyPerson = securityCompanyPersonDao.findByPersonId(person.getId());
        problemPerson.setUpdateTime(new Date());
        problemPerson.setActive(true);
        problemPerson.setUpdateBy("systemAutoCriminal");
        problemPerson.setIdnumber(idNumber);
        //就职状态
        problemPerson.setIncumbencyStatus(person.getIncumbencyStatus());
        //获取公司信息
        if (securityCompanyPerson != null) {
            if (securityCompanyPerson.getCompany() != null) {
                //公司名称
                problemPerson.setCompanyid(securityCompanyPerson.getCompany().getId());
                //公司主键
                problemPerson.setCompanyname(securityCompanyPerson.getCompany().getName());
                //监控机构ID
                if (StringUtil.isNotEmpty(securityCompanyPerson.getCompany().getOrgId())) {
                    problemPerson.setOrgId(Long.valueOf(securityCompanyPerson.getCompany().getOrgId()));
                }
                //监控机构名称
                problemPerson.setOrgName(securityCompanyPerson.getCompany().getOrgName());
                //所属区域
                problemPerson.setAreaCode(securityCompanyPerson.getCompany().getAreaCode());
            }
        }
        //手机
        problemPerson.setPhone(person.getPhone());
        //姓名
        problemPerson.setName(person.getRealName());
        //性别
        problemPerson.setSex(person.getGender());
        //人员
        problemPerson.setPersonid(person.getId());
        problemPerson.setUpdateflag(true);
        if (!result) {
            //信息有误
            if(Constants.LIBRARYTYPE_CZ_FAIL_MESSAGE.equals(problemtype.toString()) || Constants.LIBRARYTYPE_CZ_FAIL.equals(problemtype.toString())){
                problemPerson.setPersonType(Constants.PERSONTYPE_INFO);
                //在逃
            } else if(problemtype.toString().indexOf(Constants.LIBRARYTYPE_DT_QUERY) >0){
                problemPerson.setPersonType(Constants.PERSONTYPE_LARGE);
                //前科
            }else{
                problemPerson.setPersonType(Constants.PERSONTYPE_CRIMINAL);
            }
            //问题类型
            problemPerson.setProblemtype(problemtype.toString());
            if(problemPerson.getId()!=null){
                problemPersonDaoAop.update(problemPerson);
            }else{
                //只有背景筛查不通过再生成记录
                problemPersonDao.save(problemPerson);
            }
        }
    }

    /***
     * 保安员背景筛查保存到问题人员表
     * 所有子类共用此方法 不可@Override重写
     * @param person 问题人员
     * @return 背景筛查结果
     */
    public final void censorSaveProblemPersonCriminal(SecurityPerson person, List<BackgroundApproval> backgroundApprovals) {
        //身份证号码
        String idNumber = person.getIdNumber();
        //姓名
        String name = person.getRealName();
        //问题人员
        ProblemPerson problemPerson  = new ProblemPerson();
        //查询对象
        ProblemPerson query =  new ProblemPerson();
        query.setPersonid(person.getId());
        query.setDispose(Constants.DISPOSE_NO);
        List<ProblemPerson> list = problemPersonDao.findByPersonIdForUnDispose(query);
        if(list!=null && list.size()>0){
            problemPerson =  list.get(0);
        }else {
            problemPerson.setCreateTime(new Date());
            //处理状态
            problemPerson.setDispose(Constants.DISPOSE_NO);
        }
        problemPerson.setComparisonDate(new Date());
        //如果身份证号为空，显示返回
        if (person == null) {
            logger.error("异常身份证号：" + idNumber);
            return ;
        }
        SecurityCompanyPerson securityCompanyPerson = securityCompanyPersonDao.findByPersonId(person.getId());
        problemPerson.setUpdateTime(new Date());
        problemPerson.setActive(true);
        problemPerson.setUpdateBy("systemAuto");
        problemPerson.setIdnumber(idNumber);
        //就职状态
        problemPerson.setIncumbencyStatus(person.getIncumbencyStatus());
        //获取公司信息
        if (securityCompanyPerson != null) {
            if (securityCompanyPerson.getCompany() != null) {
                //公司名称
                problemPerson.setCompanyid(securityCompanyPerson.getCompany().getId());
                //公司主键
                problemPerson.setCompanyname(securityCompanyPerson.getCompany().getName());
                //监控机构ID
                if (StringUtil.isNotEmpty(securityCompanyPerson.getCompany().getOrgId())) {
                    problemPerson.setOrgId(Long.valueOf(securityCompanyPerson.getCompany().getOrgId()));
                }
                //监控机构名称
                problemPerson.setOrgName(securityCompanyPerson.getCompany().getOrgName());
                //所属区域
                problemPerson.setAreaCode(securityCompanyPerson.getCompany().getAreaCode());
            }
        }
        //手机
        problemPerson.setPhone(person.getPhone());
        //姓名
        problemPerson.setName(person.getRealName());
        //性别
        problemPerson.setSex(person.getGender());
        //人员
        problemPerson.setPersonid(person.getId());
        //背景筛查标记
        boolean result = true;
        //判断类型是否存在数据库
        boolean existsFlag = false;
        StringBuffer problemtype =  new StringBuffer();
        //循环背景筛查记录，检查是否有不通过
        for (BackgroundApproval backgroundApproval : backgroundApprovals) {
            if(ApprovalState.SHBTG.equals(backgroundApproval.getApprovalstate())){
                problemtype.append(backgroundApproval.getApprovalreason()).append(Constants.COMMA);
                result = false;
            }
        }
        problemPerson.setUpdateflag(true);
        List<ProblemPerson> dbList = problemPersonDao.findByPersonIdForMax(query);
        if (!result) {
            //新比对类型
            String[] problemtypes =  problemtype.toString().split(Constants.COMMA);
            for (String type:problemtypes) {
                //有违法犯罪记录和违法犯罪转换成同一个类型
                type = type.replaceAll("有违法犯罪记录","违法犯罪");
                //姓名信息有误和身份证号不存在不对比
                if("姓名信息有误".equals(type) || "身份证号不存在".equals(type)){
                    continue;
                }
                for(ProblemPerson p:dbList){
                    //已存在的问题类型
                    String[] dbProblemtypes = p.getProblemtype().split(Constants.COMMA);
                    for(String dbType:dbProblemtypes){
                        //姓名信息有误和身份证号不存在不对比
                        if("姓名信息有误".equals(dbType) || "身份证号不存在".equals(dbType)){
                            continue;
                        }
                        //有违法犯罪记录和违法犯罪转换成同一个类型
                        dbType = dbType.replaceAll("有违法犯罪记录","违法犯罪");
                        if(StringUtil.trim(dbType).equals(StringUtil.trim(type))){
                            existsFlag = true;
                            break;
                        }
                    }
                    if(existsFlag){
                        break;
                    }
                }
            }
            //如果类型在之前的列表中不存在，生成新的数据
            if(!existsFlag) {
                //去悼最后一位
                problemtype.deleteCharAt(problemtype.length() - 1);
                //信息有误
                if (Constants.LIBRARYTYPE_CZ_FAIL_MESSAGE.equals(problemtype.toString()) || Constants.LIBRARYTYPE_CZ_FAIL.equals(problemtype.toString())) {
                    problemPerson.setPersonType(Constants.PERSONTYPE_INFO);
                    //在逃
                } else if (problemtype.toString().indexOf(Constants.LIBRARYTYPE_DT_QUERY) > 0) {
                    problemPerson.setPersonType(Constants.PERSONTYPE_LARGE);
                    //前科
                } else {
                    problemPerson.setPersonType(Constants.PERSONTYPE_CRIMINAL);
                }
                //问题类型
                problemPerson.setProblemtype(problemtype.toString());
                if (problemPerson.getId() != null) {
                    problemPersonDaoAop.update(problemPerson);
                } else {
                    //只有背景筛查不通过再生成记录
                    problemPersonDao.save(problemPerson);
                }
            }
        }else{
            if(problemPerson.getId()!=null){
                problemPerson.setActive(false);
                //只有背景筛查不通过再生成记录
                problemPersonDaoAop.update(problemPerson);
            }
        }
        //更新人员信息的背景筛查状态
        if (result) {
            //背景筛查状态，第一次
            person.setCensorStatus(Constants.CENSORSTATUS_PASS);
            //前科背景筛查状态
            person.setCensorCriminalStatus(Constants.CENSORSTATUS_PASS);
            //背景筛查通过后，人员关联旧数据证书，判断证书是否存在，存在则关联
            //this.updateCerForOldData(problemPerson);
        } else {
            //背景筛查状态，第一次
            person.setCensorStatus(Constants.CENSORSTATUS_UNPASS);
            //前科背景筛查状态
            person.setCensorCriminalStatus(Constants.CENSORSTATUS_UNPASS);
        }
        person.setCensorTime(new Date());
        //更新前科背景筛查记录
        personDaoAop.updateSelective(person);
    }

    /****
     * 背景筛查并保存数据库
     * @param dto 业务信息
     */
    public final List<BackgroundApproval> censor(BackgroundApprovalDto dto) {
        String name = dto.getRealName();
        //如果姓名没传，先查询
        if(StringUtil.isEmpty(name)) {
            name = clientUtil.getName(dto.getBusinessid(), dto.getBusinesstype());
        }
        if(StringUtil.isEmpty(name)) {
            throw new ArsException("businessid:"+dto.getBusinessid()+",businesstype:"+dto.getBusinesstype()+"无法获取到姓名!");
        }
        dto.setRealName(name);
        //先查询
        List<BackgroundApproval> backgroundApprovals = getCensorResult(dto);
        //问题人员无须保存
        if(!Constants.BAY_FZR.equals(dto.getBusinesstype()) && backgroundApprovals != null && backgroundApprovals.size() > 0) {
            //如果有记录的话，删除以前记录信息
            backgroundApprovalDao.delete(dto);
            //批量保存
            backgroundApprovalDao.batchSave(backgroundApprovals);
        }
        return backgroundApprovals;

    }


    public List<BackgroundApproval> censorFromBase(BackgroundApprovalDto dto,boolean needCZ){
        return null;
    }


    public final String getCensorStatus(BackgroundApprovalDto dto) {
        List<BackgroundApproval> list = censor(dto);
        for(BackgroundApproval detail:list){
            if(Constants.CENSORSTATUS_UNPASS.equals(detail.getApprovalstate())){
                return Constants.CENSORSTATUS_UNPASS;
            }
        }
        return Constants.CENSORSTATUS_PASS;
    }

    public final String getCensorResult(String idNumber, String name) {
        BackgroundApprovalDto dto = new BackgroundApprovalDto();
        dto.setIdNumber(idNumber);
        dto.setRealName(name);
        List<BackgroundApproval> backgroundApprovals = getCensorResult(dto);
        return getCensorResult(backgroundApprovals);
    }

}
