/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.webservice.police.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dao.sb.BackgroundApprovalDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.ftp.FtpUtils;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.webservice.dto.SNCensorResult;
import com.bcxin.ars.webservice.dto.SNPerInfoDto;
import com.bcxin.ars.webservice.police.SecurityInterfaceService;
import com.bcxin.ars.webservice.police.enums.ResultType;
import com.bcxin.ars.webservice.util.SubStringUtil;
import com.dragonsoft.node.adapter.comm.RbspCall;
import com.dragonsoft.node.adapter.comm.RbspService;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="securityInterfaceService_610000")
public class SNSecurityInterfaceService
implements SecurityInterfaceService {
    private static Logger logger = LoggerFactory.getLogger(SNSecurityInterfaceService.class);
    @Autowired
    private BjRestLogDao bjRestLogDao;
    @Value(value="${ZAFLAG}")
    private String ZAFLAG;
    @Value(value="${ZAURL}")
    private String ZAURL;
    @Autowired
    private ConfigService configService;
    @Autowired
    private SysareaService sysareaService;
    @Autowired
    private BackgroundApprovalDao backgroundApprovalDao;
    @Autowired
    private RedisUtil redisUtil;

    private String call(String requestID, String serviceID, List<String> idnums, String[] requiredItems) {
        String result = "";
        String key = DateUtil.getCurrentDate((String)"yyyyMMdd") + "_" + serviceID;
        String count = this.redisUtil.get(key);
        if (StringUtil.isNotEmpty((String)count)) {
            Long total = Long.parseLong(count);
            Long max = 8000L;
            try {
                String configValue = this.configService.getValueByKey("POLICE_INTERFACE_MAX");
                max = Long.parseLong(configValue);
            }
            catch (Exception configValue) {
                // empty catch block
            }
            if (total >= max) {
                return result;
            }
        }
        this.redisUtil.getCount(key, 7L);
        RbspService service = new RbspService(requestID, serviceID);
        service.setUserCardId("asdfasd");
        service.setUserDept("0100");
        service.setUserName("ptjian");
        RbspCall call = service.createCall();
        call.setUrl(this.ZAURL);
        call.setMethod("Query");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("DataObjectCode", "M001");
        params.put("InfoCodeMode", "1");
        params.put("Condition", "SFZH in (" + SubStringUtil.getStr(idnums) + ")");
        params.put("RequiredItems", requiredItems);
        logger.error("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.ZAURL);
        logger.error("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
        result = call.invoke(params);
        logger.error("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        return result;
    }

    @Override
    public Map<String, PersonBaseInfo> getPersonInfo(List<String> idnums, ResultType resultType) {
        return this.getPersonInfo("C61-00000024", "S10-00000298", idnums, resultType);
    }

    @Override
    public Map<String, PersonBaseInfo> getNewPersonInfo(List<String> idnums) {
        return this.getPopulationInfo(idnums, true);
    }

    @Override
    public void censorPerson(List<SecurityPerson> personList) {
        List<String> idnumList = personList.stream().map(SecurityPerson::getIdNumber).collect(Collectors.toList());
        Map<String, PersonBaseInfo> personMap = this.getPersonInfo(idnumList, ResultType.NAME);
        Map<String, PersonBaseInfo> xdMap = this.getPersonInfo("C61-00000024", "S10-00000009", idnumList, ResultType.NAME);
        Map<String, PersonBaseInfo> wfMap = this.getPersonInfo("C61-00000024", "S10-00000007", idnumList, ResultType.NAME);
        Map<String, PersonBaseInfo> dtMap = this.getPersonInfo("C61-00000024", "S10-00000006", idnumList, ResultType.NAME);
        for (SecurityPerson securityPerson : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            dto.setIdNumber(securityPerson.getIdNumber());
            dto.setRealName(securityPerson.getRealName());
            dto.setBusinessid(securityPerson.getId());
            dto.setBusinesstype("15");
            dto.setAuthState(securityPerson.getIdentityAuthState());
            securityPerson.setBackgroundApprovals(this.censor(dto, personMap.get(securityPerson.getIdNumber()), xdMap.get(securityPerson.getIdNumber()), wfMap.get(securityPerson.getIdNumber()), dtMap.get(securityPerson.getIdNumber())));
        }
    }

    @Override
    public void censoRenrollQualification(List<Personcertificate> personList) {
        List<String> idnumList = personList.stream().map(Personcertificate::getCardnumber).collect(Collectors.toList());
        Map<String, PersonBaseInfo> personMap = this.getPersonInfo(idnumList, ResultType.PERSON);
        Map<String, PersonBaseInfo> xdMap = this.getPersonInfo("C61-00000024", "S10-00000009", idnumList, ResultType.NAME);
        Map<String, PersonBaseInfo> wfMap = this.getPersonInfo("C61-00000024", "S10-00000007", idnumList, ResultType.NAME);
        Map<String, PersonBaseInfo> dtMap = this.getPersonInfo("C61-00000024", "S10-00000006", idnumList, ResultType.NAME);
        for (Personcertificate personcertificate : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            dto.setBusinessid(personcertificate.getId());
            dto.setBusinesstype("5");
            dto.setIdNumber(personcertificate.getCardnumber());
            dto.setRealName(personcertificate.getName());
            PersonBaseInfo personBaseInfo = personMap.get(personcertificate.getCardnumber());
            if (personBaseInfo != null && StringUtil.isNotEmpty((String)personBaseInfo.getAddress())) {
                personcertificate.setPopulationAddress(personBaseInfo.getAddress());
            }
            personcertificate.setBackgroundApprovals(this.censor(dto, personBaseInfo, xdMap.get(personcertificate.getCardnumber()), wfMap.get(personcertificate.getCardnumber()), dtMap.get(personcertificate.getCardnumber())));
        }
    }

    @Override
    public void censorNewPerson(List<SecurityPerson> personList) {
        List<String> idnumList = personList.stream().map(SecurityPerson::getIdNumber).collect(Collectors.toList());
        Map<String, PersonBaseInfo> personMap = this.getSNCensorResult(idnumList, "1");
        Map<String, PersonBaseInfo> xdMap = this.getSNCensorResult(idnumList, "2");
        Map<String, PersonBaseInfo> wfMap = this.getSNCensorResult(idnumList, "4");
        Map<String, PersonBaseInfo> dtMap = this.getSNCensorResult(idnumList, "3");
        for (SecurityPerson securityPerson : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            dto.setIdNumber(securityPerson.getIdNumber());
            dto.setRealName(securityPerson.getRealName());
            dto.setBusinessid(securityPerson.getId());
            dto.setBusinesstype("15");
            dto.setAuthState(securityPerson.getIdentityAuthState());
            securityPerson.setBackgroundApprovals(this.censor(dto, personMap.get(securityPerson.getIdNumber()), xdMap.get(securityPerson.getIdNumber()), wfMap.get(securityPerson.getIdNumber()), dtMap.get(securityPerson.getIdNumber())));
        }
    }

    public Map<String, PersonBaseInfo> getPopulationInfo(List<String> idnumList, boolean needPhoto) {
        HashMap<String, PersonBaseInfo> personList = new HashMap<String, PersonBaseInfo>();
        String code = "";
        boolean errorCount = false;
        String key = DateUtil.getCurrentDate((String)"yyyyMMdd") + "_" + "S10-00000298";
        String count = this.redisUtil.get(key);
        if (StringUtil.isNotEmpty((String)count)) {
            Long total = Long.parseLong(count);
            Long max = 8000L;
            try {
                String configValue = this.configService.getValueByKey("POLICE_INTERFACE_MAX");
                max = Long.parseLong(configValue);
            }
            catch (Exception configValue) {
                // empty catch block
            }
            if (total >= max) {
                return personList;
            }
        }
        for (String idNumber : idnumList) {
            JSONObject jsonObject;
            SNPerInfoDto snPerInfo;
            PersonBaseInfo person = new PersonBaseInfo();
            String url = "http://92.1.31.17/datac/service/support/es/query";
            HashMap snPersonParams = Maps.newHashMap();
            snPersonParams.put("resId", "49");
            snPersonParams.put("sql", " (`GMSFHM`=?)");
            snPersonParams.put("accessId", "ba3146d4");
            snPersonParams.put("accessKey", "99565732e1654334859d52ae98b52c77");
            snPersonParams.put("reqId", "40");
            snPersonParams.put("queryValues", String.format("[{\"type\":\"string\",\"value\":\"%s\"}]", idNumber));
            logger.error("snPersonRequestUrl:{}", (Object)url);
            logger.error("snPersonParams:{}", (Object)JSON.toJSONString((Object)snPersonParams));
            String responseContent = HttpUtil.post((String)url, (Map)snPersonParams);
            logger.error("\u9655\u897f\u80cc\u666f\u7b5b\u67e5\u672c\u7701\u5e93\u67e5\u8be2{}\u8fd4\u56de:{}", (Object)idNumber, (Object)responseContent);
            SNCensorResult snCensorResult = (SNCensorResult)JSON.parseObject((String)responseContent, SNCensorResult.class);
            logger.error("snCensorResult:{}", (Object)snCensorResult);
            JSONArray data = snCensorResult.getData();
            if (data.size() <= 0 || (snPerInfo = (SNPerInfoDto)JSON.toJavaObject((JSON)(jsonObject = (JSONObject)data.get(0)), SNPerInfoDto.class)) == null) continue;
            if (needPhoto) {
                String xp = snPerInfo.getZp();
                String path = xp.substring(0, xp.lastIndexOf("/"));
                String fileName = xp.substring(xp.lastIndexOf("/") + 1);
                InputStream photoInputStream = FtpUtils.downloadFile((String)"92.1.31.25", (String)"xyyh", (String)"xyyh@123", (int)12100, (String)path, (String)fileName);
                byte[] bytes = IoUtil.readBytes((InputStream)photoInputStream);
                String base64Code = Base64.getEncoder().encodeToString(bytes);
                person.setPhoto(base64Code);
            }
            person.setName(snPerInfo.getXm());
            person.setIdnum(snPerInfo.getGmsfhm());
            String areaAdd = this.sysareaService.findByCodeForFullName(snPerInfo.getCSDSSXDM());
            String address = areaAdd + snPerInfo.getCHUSD_QHNXXDZ().replace(areaAdd, "");
            person.setAddress(address);
            personList.put(idNumber, person);
        }
        return personList;
    }

    @Override
    public void censorNewQualification(List<Personcertificate> personList) {
        List<String> idnumList = personList.stream().map(Personcertificate::getCardnumber).collect(Collectors.toList());
        Map<String, PersonBaseInfo> personMap = this.getPopulationInfo(idnumList, false);
        Map<String, PersonBaseInfo> xdMap = this.getSNCensorResult(idnumList, "2");
        Map<String, PersonBaseInfo> wfMap = this.getSNCensorResult(idnumList, "4");
        Map<String, PersonBaseInfo> dtMap = this.getSNCensorResult(idnumList, "3");
        for (Personcertificate personcertificate : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            dto.setBusinessid(personcertificate.getId());
            dto.setBusinesstype("5");
            dto.setIdNumber(personcertificate.getCardnumber());
            dto.setRealName(personcertificate.getName());
            PersonBaseInfo personBaseInfo = personMap.get(personcertificate.getCardnumber());
            if (personBaseInfo != null && StringUtil.isNotEmpty((String)personBaseInfo.getAddress())) {
                personcertificate.setPopulationAddress(personBaseInfo.getAddress());
            }
            personcertificate.setBackgroundApprovals(this.censor(dto, personBaseInfo, xdMap.get(personcertificate.getCardnumber()), wfMap.get(personcertificate.getCardnumber()), dtMap.get(personcertificate.getCardnumber())));
        }
    }

    public List<BackgroundApproval> censor(BackgroundApprovalDto dto, PersonBaseInfo czPerson, PersonBaseInfo xdPerson, PersonBaseInfo wfPerson, PersonBaseInfo dtPerson) {
        ArrayList<BackgroundApproval> list = new ArrayList<BackgroundApproval>();
        try {
            BackgroundApproval backgroundApproval = new BackgroundApproval();
            backgroundApproval.setActive(Boolean.valueOf(true));
            backgroundApproval.setCreateTime(new Date());
            backgroundApproval.setUpdateTime(new Date());
            backgroundApproval.setApprovaldate(new Date());
            backgroundApproval.setBusinesstype(dto.getBusinesstype());
            backgroundApproval.setBusinessid(dto.getBusinessid());
            BackgroundApproval cz_BackgroundApproval = backgroundApproval.clone();
            cz_BackgroundApproval.setLibraryType("1");
            BackgroundApproval xd_BackgroundApproval = cz_BackgroundApproval.clone();
            xd_BackgroundApproval.setLibraryType("2");
            BackgroundApproval dt_BackgroundApproval = cz_BackgroundApproval.clone();
            dt_BackgroundApproval.setLibraryType("3");
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();
            wf_BackgroundApproval.setLibraryType("4");
            if (czPerson != null) {
                if (StringUtil.isNotEmpty((String)czPerson.getName()) && dto.getRealName().equals(czPerson.getName())) {
                    cz_BackgroundApproval.setApprovalreason("\u4e3b\u9879\u4fe1\u606f\u7b26\u5408");
                    cz_BackgroundApproval.setApprovalstate("003");
                    cz_BackgroundApproval.setRgapprovalstate("003");
                } else {
                    cz_BackgroundApproval.setApprovalreason("\u59d3\u540d\u4fe1\u606f\u6709\u8bef");
                    cz_BackgroundApproval.setApprovalstate("004");
                    cz_BackgroundApproval.setRgapprovalstate("004");
                }
            } else {
                cz_BackgroundApproval.setApprovalreason("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728");
                cz_BackgroundApproval.setApprovalstate("004");
                cz_BackgroundApproval.setRgapprovalstate("004");
            }
            list.add(cz_BackgroundApproval);
            if (xdPerson != null) {
                xd_BackgroundApproval.setApprovalreason("\u5438\u6bd2\u4eba\u5458");
                xd_BackgroundApproval.setApprovalstate("004");
                xd_BackgroundApproval.setRgapprovalstate("004");
            } else {
                xd_BackgroundApproval.setApprovalreason("\u65e0\u5438\u6bd2\u8bb0\u5f55");
                xd_BackgroundApproval.setApprovalstate("003");
                xd_BackgroundApproval.setRgapprovalstate("003");
            }
            list.add(xd_BackgroundApproval);
            if (dtPerson != null) {
                dt_BackgroundApproval.setApprovalreason("\u5728\u9003\u4eba\u5458");
                dt_BackgroundApproval.setApprovalstate("004");
                dt_BackgroundApproval.setRgapprovalstate("004");
            } else {
                dt_BackgroundApproval.setApprovalreason("\u65e0\u5728\u9003\u8bb0\u5f55");
                dt_BackgroundApproval.setApprovalstate("003");
                dt_BackgroundApproval.setRgapprovalstate("003");
            }
            list.add(dt_BackgroundApproval);
            if (wfPerson != null) {
                wf_BackgroundApproval.setApprovalreason("\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55");
                wf_BackgroundApproval.setApprovalstate("004");
                wf_BackgroundApproval.setRgapprovalstate("004");
            } else {
                wf_BackgroundApproval.setApprovalreason("\u65e0\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55");
                wf_BackgroundApproval.setApprovalstate("003");
                wf_BackgroundApproval.setRgapprovalstate("003");
            }
            list.add(wf_BackgroundApproval);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!"15".equals(dto.getBusinesstype()) && list != null && list.size() > 0) {
            this.backgroundApprovalDao.delete(dto);
            this.backgroundApprovalDao.batchSave(list);
        }
        return list;
    }

    public Map<String, PersonBaseInfo> getPersonInfo(String requestID, String serviceID, List<String> idnums, ResultType resultType) {
        HashMap<String, PersonBaseInfo> personList = new HashMap<String, PersonBaseInfo>();
        String code = "";
        if (this.ZAFLAG != null && this.ZAFLAG.equals("1")) {
            for (int i = 0; i < 3; ++i) {
                String[] requiredItems = null;
                switch (resultType) {
                    case NAME: {
                        requiredItems = new String[]{"SFZH", Constants.INFO_XM};
                        break;
                    }
                    case PHOTO: {
                        requiredItems = new String[]{"SFZH", Constants.INFO_XM, Constants.INFO_XP};
                        break;
                    }
                    case PERSON: {
                        requiredItems = new String[]{"SFZH", Constants.INFO_XM, Constants.INFO_JGSSX, Constants.INFO_ZZXZ};
                        break;
                    }
                    default: {
                        requiredItems = new String[]{"SFZH", Constants.INFO_XM, Constants.INFO_JGSSX, Constants.INFO_ZZXZ, Constants.INFO_XP};
                    }
                }
                String requestResult = this.call(requestID, serviceID, idnums, requiredItems);
                BjRestLog log = new BjRestLog();
                log.setResttype(serviceID);
                if (!resultType.equals((Object)ResultType.PHOTO) && !resultType.equals((Object)ResultType.ALL)) {
                    log.setResponseContext(requestResult);
                }
                log.setRequestContext(JSON.toJSONString(idnums));
                log.setCreateTime(new Date());
                log.setActive(Boolean.valueOf(true));
                log.setUpdateTime(new Date());
                log.setUpdateBy("system");
                this.bjRestLogDao.save(log);
                if (requestResult != null && !requestResult.equals("")) {
                    try {
                        String pattern = "\\s{2,}";
                        Pattern r = Pattern.compile(pattern);
                        Matcher m = r.matcher(requestResult);
                        requestResult = m.replaceAll("");
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read((InputStream)new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
                        Element root = doc.getRootElement();
                        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                        if (valueElement != null) {
                            List list = valueElement.elements();
                            if (list != null && list.size() > 0) {
                                Element e = (Element)list.get(0);
                                code = e.element("Data").getText();
                            }
                            if (list != null && list.size() > 2) {
                                PersonBaseInfo person = null;
                                for (int j = 2; j < list.size(); ++j) {
                                    Element e = (Element)list.get(j);
                                    person = new PersonBaseInfo();
                                    switch (resultType) {
                                        case NAME: {
                                            this.getPersonName(person, e.content());
                                            break;
                                        }
                                        case PHOTO: {
                                            this.getPersonPhoto(person, e.content());
                                            break;
                                        }
                                        case PERSON: {
                                            this.getPerson(person, e.content());
                                            break;
                                        }
                                        default: {
                                            this.getAll(person, e.content());
                                        }
                                    }
                                    personList.put(person.getIdnum(), person);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u4eba\u53e3\u5e93\u83b7\u53d6\u5f02\u5e38\uff1a");
                        logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                }
                if (!"000".equals(code)) {
                    continue;
                }
                break;
            }
        } else {
            code = "000";
        }
        if (!"000".equals(code)) {
            throw new ArsException("\u9655\u897f\u4eba\u53e3\u5e93\u8c03\u7528\u5f02\u5e38\uff01");
        }
        return personList;
    }

    private void getPersonName(PersonBaseInfo person, List contents) {
        person.setIdnum(((DefaultElement)contents.get(0)).getText());
        person.setName(((DefaultElement)contents.get(1)).getText());
    }

    private void getPersonPhoto(PersonBaseInfo person, List contents) {
        this.getPersonName(person, contents);
        person.setPhoto(((DefaultElement)contents.get(2)).getText());
    }

    private void getPerson(PersonBaseInfo person, List contents) {
        this.getPersonName(person, contents);
        String address = ((DefaultElement)contents.get(3)).getText();
        String areaAdd = this.sysareaService.findByCodeForFullName(((DefaultElement)contents.get(2)).getText());
        address = areaAdd + address.replace(areaAdd, "");
        person.setAddress(address);
    }

    private void getAll(PersonBaseInfo person, List contents) {
        this.getPerson(person, contents);
        person.setPhoto(((DefaultElement)contents.get(4)).getText());
    }

    private Map<String, PersonBaseInfo> getTest(ResultType resultType) {
        HashMap<String, PersonBaseInfo> personList = new HashMap<String, PersonBaseInfo>();
        String requestResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><RBSPMessage>    <Version/>    <ServiceID>S10-00000006</ServiceID>    <TimeStamp/>    <Validity/>    <Security>        <Signature Algorithm=\"\"/>        <CheckCode Algorithm=\"\"/>        <Encrypt/>    </Security>    <Method>        <Name>Query</Name>        <Items>            <Item>                <Value Type=\"arrayOfArrayOf_string\">                    <Row>                        <Data>000</Data>                    </Row>                    <Row>                        <Data>XM</Data>                    </Row>                </Value>            </Item>        </Items>    </Method></RBSPMessage>";
        String pattern = "\\s{2,}";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(requestResult);
        requestResult = m.replaceAll("");
        if (requestResult != null && !requestResult.equals("")) {
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read((InputStream)new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
                Element root = doc.getRootElement();
                Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                if (valueElement != null) {
                    List list = valueElement.elements();
                    if (list != null && list.size() > 0) {
                        Element element = (Element)list.get(0);
                    }
                    if (list != null && list.size() > 2) {
                        PersonBaseInfo person = null;
                        for (int j = 2; j < list.size(); ++j) {
                            Element e = (Element)list.get(j);
                            person = new PersonBaseInfo();
                            switch (resultType) {
                                case NAME: {
                                    this.getPersonName(person, e.content());
                                    break;
                                }
                                case PHOTO: {
                                    this.getPersonPhoto(person, e.content());
                                    break;
                                }
                                case PERSON: {
                                    this.getPerson(person, e.content());
                                    break;
                                }
                                default: {
                                    this.getAll(person, e.content());
                                }
                            }
                            personList.put(person.getIdnum(), person);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u4eba\u53e3\u5e93\u83b7\u53d6\u5f02\u5e38\uff1a");
                logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return personList;
    }

    public static void main(String[] args) {
        SNSecurityInterfaceService securityInterfaceService = new SNSecurityInterfaceService();
        Map<String, PersonBaseInfo> personList = securityInterfaceService.getTest(ResultType.PERSON);
        System.out.println(JSON.toJSONString(personList));
    }

    private Map<String, PersonBaseInfo> getSNCensorResult(List<String> idnumList, String type) {
        HashMap<String, PersonBaseInfo> personList = new HashMap<String, PersonBaseInfo>();
        for (String idNumber : idnumList) {
            PersonBaseInfo person = new PersonBaseInfo();
            String requestUrl = "http://92.1.31.17/datac/service/support/es/query";
            HashMap params = Maps.newHashMap();
            switch (type) {
                case "3": {
                    params.put("resId", "38");
                    params.put("sql", "(`ZJHM`=? and `ryzt_jyqk`=0)");
                    break;
                }
                case "4": {
                    params.put("resId", "62");
                    params.put("sql", "(`ZJHM`=? and `ryjbxxbj` in ('0','1','5'))");
                    break;
                }
                case "2": {
                    params.put("resId", "57");
                    params.put("sql", "(`gmsfhm`=? and `yxx`=1)");
                    break;
                }
                case "1": {
                    params.put("resId", "49");
                    params.put("sql", " (`GMSFHM`=?)");
                    break;
                }
                default: {
                    return personList;
                }
            }
            params.put("accessId", "ba3146d4");
            params.put("accessKey", "99565732e1654334859d52ae98b52c77");
            params.put("reqId", "40");
            params.put("queryValues", String.format("[{\"type\":\"string\",\"value\":\"%s\"}]", idNumber));
            logger.error("CensorRequestUrl:{}", (Object)requestUrl);
            logger.error("censorParams:{}", (Object)JSON.toJSONString((Object)params));
            String responseContent = HttpUtil.post((String)requestUrl, (Map)params);
            logger.error("\u9655\u897f\u80cc\u666f\u7b5b\u67e5\u65b0\u5e93\u67e5\u8be2{}\u8fd4\u56de:{}", (Object)idNumber, (Object)responseContent);
            SNCensorResult snCensorResult = (SNCensorResult)JSON.parseObject((String)responseContent, SNCensorResult.class);
            logger.error("snCensorResult:{}", (Object)snCensorResult);
            JSONArray data = snCensorResult.getData();
            if (data.size() <= 0) continue;
            JSONObject jsonObject = (JSONObject)data.get(0);
            SNPerInfoDto snPerInfo = (SNPerInfoDto)JSON.toJavaObject((JSON)jsonObject, SNPerInfoDto.class);
            logger.error("snPerInfo:{}", (Object)snPerInfo);
            if (snPerInfo == null) continue;
            person.setName(snPerInfo.getXm());
            person.setIdnum(idNumber);
            personList.put(idNumber, person);
        }
        return personList;
    }
}

