<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<table class="table"> 
			  <thead>
			    <tr>
			      <th>活动名称</th>
			      <th>活动时间</th>
			      <th>活动地点</th>
			      <th>联系人</th>
				  <th>勘查专家</th>
			      <th>状态</th>
			      <th>操作</th>
			    </tr>
			  </thead>
			  <tbody id="taskList">
			  	<c:choose>
			  		<c:when test="${empty taskList }">
			  			<tr><td colspan="7" style="text-align: center;">无相关数据</td></tr>
			  		</c:when>
			  		<c:otherwise>
			  			<c:forEach items="${taskList }" var="surveyTask">
							<tr>
								<td>${surveyTask.activityName }</td>
								<td>${surveyTask.startDate }<br>-<br>${surveyTask.endDate }</td>
								<td>${surveyTask.address }&nbsp;</td>
								<td>${surveyTask.contacts }<br/>${surveyTask.contactMobile }&nbsp;</td>
								<td>
									<c:if test="${not empty surveyTask.tkExperts}">
										<c:set value="${fn:split(surveyTask.tkExperts,',')}" var="experts" />
										<c:forEach items="${experts}" var="item">
											${item}<br/>
										</c:forEach>
									</c:if>
									<c:if test="${ empty surveyTask.tkExperts}">
										--
									</c:if>
								</td>
								<td id="showStatus${surveyTask.oid }">${surveyTask.surveyTaskStatusName }</td>
								<td id="showBt${surveyTask.oid }">
									<c:if test="${surveyTask.surveyTaskStatus eq 'DISTRIBUTE' }">
										<a href="javascript:void(0);" onclick="receiveTask('${surveyTask.oid }');">接受 |</a> 
										<a href="javascript:void(0);" onclick="refuse('${surveyTask.oid }');">拒绝</a>
									</c:if>
									<c:if test="${surveyTask.surveyTaskStatus eq 'DOING'}">						
										<a href="javascript:taskDetail('${surveyTask.oid }');" id="planBtn">查看详情</a>	
									</c:if>
								</td>
							</tr>
						</c:forEach>
			  		</c:otherwise>
			  	</c:choose>
			  </tbody>
			</table>
			<form id="taskForm">
            	<input type="hidden" name="surveyTaskStatus" id="surveyTaskStatus" value="ALL">
            	<input type="hidden" name="search" id="search" value="">
            	<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
            	<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
            	<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
            	<c:if test="${not empty taskList }">
            		<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
            	</c:if>
            </form>
<script type="text/javascript">
	var totalCount = Number($('#totalCount').val()) || 20;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 10;
	$('#callBackPager').extendPagination({
		totalCount : totalCount,
		showCount : showCount,
		limit : limit,
		callback : function(curr, limit, totalCount) {
			getListForPage("taskForm", "taskList");
		}
	});
</script>
